import request from '@/utils/request'

// 查询车辆使用记录列表
export function listRecord(query) {
  return request({
    url: '/system/record/list',
    method: 'get',
    params: query
  })
}

// 查询车辆使用记录详细
export function getRecord(vehicleUseRecordId) {
  return request({
    url: '/system/record/' + vehicleUseRecordId,
    method: 'get'
  })
}

// 新增车辆使用记录
export function addRecord(data) {
  return request({
    url: '/system/record',
    method: 'post',
    data: data
  })
}

// 修改车辆使用记录
export function updateRecord(data) {
  return request({
    url: '/system/record',
    method: 'put',
    data: data
  })
}

// 删除车辆使用记录
export function delRecord(vehicleUseRecordId) {
  return request({
    url: '/system/record/' + vehicleUseRecordId,
    method: 'delete'
  })
}

// 导出车辆使用记录
export function exportRecord(query) {
  return request({
    url: '/system/record/export',
    method: 'get',
    params: query
  })
}