import request from '@/utils/request'

// 查询燃气车辆信息列表
export function listInfo(query) {
  return request({
    url: '/system/infos/list',
    method: 'get',
    params: query
  })
}

// 查询燃气车辆信息详细
export function getInfo(vehicleId) {
  return request({
    url: '/system/infos/' + vehicleId,
    method: 'get'
  })
}

// 新增燃气车辆信息
export function addInfo(data) {
  return request({
    url: '/system/infos',
    method: 'post',
    data: data
  })
}

// 修改燃气车辆信息
export function updateInfo(data) {
  return request({
    url: '/system/infos',
    method: 'put',
    data: data
  })
}

// 删除燃气车辆信息
export function delInfo(vehicleId) {
  return request({
    url: '/system/infos/' + vehicleId,
    method: 'delete'
  })
}

// 导出燃气车辆信息
export function exportInfo(query) {
  return request({
    url: '/system/infos/export',
    method: 'get',
    params: query
  })
}
