import request from '@/utils/request'

// 查询事件处置列表
export function listHandle(query) {
  return request({
    url: '/system/handle/list',
    method: 'get',
    params: query
  })
}

// 查询事件处置详细
export function getHandle(handleId) {
  return request({
    url: '/system/handle/' + handleId,
    method: 'get'
  })
}

// 新增事件处置
export function addHandle(data) {
  return request({
    url: '/system/handle',
    method: 'post',
    data: data
  })
}

// 修改事件处置
export function updateHandle(data) {
  return request({
    url: '/system/handle',
    method: 'put',
    data: data
  })
}

// 删除事件处置
export function delHandle(handleId) {
  return request({
    url: '/system/handle/' + handleId,
    method: 'delete'
  })
}

// 导出事件处置
export function exportHandle(query) {
  return request({
    url: '/system/handle/export',
    method: 'get',
    params: query
  })
}