import request from '@/utils/request'

// 查询监督检查-调查项列表
export function listInfor(query) {
  return request({
    url: '/supervision/survey/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-调查项详细
export function getInfor(fInsSurListInforId) {
  return request({
    url: '/supervision/survey/' + fInsSurListInforId,
    method: 'get'
  })
}

// 新增监督检查-调查项
export function addInfor(data) {
  return request({
    url: '/supervision/survey',
    method: 'post',
    data: data
  })
}

// 修改监督检查-调查项
export function updateInfor(data) {
  return request({
    url: '/supervision/survey',
    method: 'put',
    data: data
  })
}

// 删除监督检查-调查项
export function delInfor(fInsSurListInforId) {
  return request({
    url: '/supervision/survey/' + fInsSurListInforId,
    method: 'delete'
  })
}

// 导出监督检查-调查项
export function exportInfor(query) {
  return request({
    url: '/supervision/survey/export',
    method: 'get',
    params: query
  })
}
