import request from '@/utils/request'

// 查询监督检查-获取检查项列表
export function listInfor(query) {
  return request({
    url: '/supervision/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-获取检查项详细
export function getInfor(fInsInsListInforId) {
  return request({
    url: '/supervision/inspect/' + fInsInsListInforId,
    method: 'get'
  })
}

// 新增监督检查-获取检查项
export function addInfor(data) {
  return request({
    url: '/supervision/inspect',
    method: 'post',
    data: data
  })
}

// 修改监督检查-获取检查项
export function updateInfor(data) {
  return request({
    url: '/supervision/inspect',
    method: 'put',
    data: data
  })
}

// 删除监督检查-获取检查项
export function delInfor(fInsInsListInforId) {
  return request({
    url: '/supervision/inspect/' + fInsInsListInforId,
    method: 'delete'
  })
}

// 导出监督检查-获取检查项
export function exportInfor(query) {
  return request({
    url: '/supervision/inspect/export',
    method: 'get',
    params: query
  })
}
