import request from '@/utils/request'

// 查询工程项目信息列表
export function listInfo(query) {
  return request({
    url: '/project/info/list',
    method: 'get',
    params: query
  })
}

export function selectNum() {
  return request({
    url: '/project/info/selectNum',
    method: 'get'
  })
}
// 查询工程项目信息详细
export function getInfo(projectId) {
  return request({
    url: '/project/info/' + projectId,
    method: 'get'
  })
}

// 新增工程项目信息
export function addInfo(data) {
  return request({
    url: '/project/info',
    method: 'post',
    data: data
  })
}

// 修改工程项目信息
export function updateInfo(data) {
  return request({
    url: '/project/info',
    method: 'put',
    data: data
  })
}

// 删除工程项目信息
export function delInfo(projectId) {
  return request({
    url: '/project/info/' + projectId,
    method: 'delete'
  })
}

// 导出工程项目信息
export function exportInfo(query) {
  return request({
    url: '/project/info/export',
    method: 'get',
    params: query
  })
}
