import request from '@/utils/request'

// 查询燃气隐患列表
export function listInfo(query) {
  return request({
    url: '/system/hidden/list',
    method: 'get',
    params: query
  })
}

// 查询燃气隐患
export function hiddenTroubleList(query) {
  return request({
    url: '/system/hidden/hiddenTroubleList',
    method: 'get',
    params: query
  })
}

// 查询燃气隐患详细
export function getInfo(hiddenTroubleId) {
  return request({
    url: '/system/hidden/' + hiddenTroubleId,
    method: 'get'
  })
}

// 新增燃气隐患
export function addHiddenInfo(data) {
  return request({
    url: '/system/hidden',
    method: 'post',
    data: data
  })
}

// 修改燃气隐患
export function updateHiddenInfo(data) {
  return request({
    url: '/system/hidden',
    method: 'put',
    data: data
  })
}

// 删除燃气隐患
export function delHiddenInfo(hiddenTroubleId) {
  return request({
    url: '/system/hidden/' + hiddenTroubleId,
    method: 'delete'
  })
}

// 导出燃气隐患
export function exportHiddenInfo(query) {
  return request({
    url: '/system/hidden/export',
    method: 'get',
    params: query
  })
}
