import request from '@/utils/request'

// 查询巡线任务列表
export function listPatrol(query) {
  return request({
    url: '/system/patrol/list',
    method: 'get',
    params: query
  })
}

// 查询巡线任务详细
export function getPatrol(patrolId) {
  return request({
    url: '/system/patrol/' + patrolId,
    method: 'get'
  })
}

// 新增巡线任务
export function addPatrol(data) {
  return request({
    url: '/system/patrol',
    method: 'post',
    data: data
  })
}

// 修改巡线任务
export function updatePatrol(data) {
  return request({
    url: '/system/patrol',
    method: 'put',
    data: data
  })
}

// 删除巡线任务
export function delPatrol(patrolId) {
  return request({
    url: '/system/patrol/' + patrolId,
    method: 'delete'
  })
}

// 导出巡线任务
export function exportPatrol(query) {
  return request({
    url: '/system/patrol/export',
    method: 'get',
    params: query
  })
}

//巡检统计
export function patrolStatistic(query) {
  return request({
    url: '/system/patrol/patrolStatistic',
    method: 'get',
    params: query
  })
}
