import request from '@/utils/request'

// 查询入户安检列表
export function listInspect(query) {
  return request({
    url: '/system/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询入户安检详细
export function getInspect(inspectId) {
  return request({
    url: '/system/inspect/' + inspectId,
    method: 'get'
  })
}

// 新增入户安检
export function addInspect(data) {
  return request({
    url: '/system/inspect',
    method: 'post',
    data: data
  })
}

// 修改入户安检
export function updateInspect(data) {
  return request({
    url: '/system/inspect',
    method: 'put',
    data: data
  })
}

// 删除入户安检
export function delInspect(inspectId) {
  return request({
    url: '/system/inspect/' + inspectId,
    method: 'delete'
  })
}

// 导出入户安检
export function exportInspect(query) {
  return request({
    url: '/system/inspect/export',
    method: 'get',
    params: query
  })
}

//入户安检统计
export function inspectStatistic(query) {
  return request({
    url: '/system/inspect/inspectStatistic',
    method: 'get',
    params: query
  })
}

export function getGasUserInspect(query) {
  return request({
    url: '/system/inspect/getGasUserInspect',
    method: 'get',
    params: query
  })
}
