import request from '@/utils/request'

// 查询燃气用户列表
export function listInfo(query) {
  return request({
    url: '/gasUser/info/list',
    method: 'get',
    params: query
  })
}

// 查询燃气用户列表
export function listInfos(query) {
  return request({
    url: '/gasUser/info/list',
    method: 'get',
    params: query
  })
}
export function gasUserInfoList(query) {
  return request({
    url: '/gasUser/info/gasUserInfoList',
    method: 'get',
    params: query
  })
}

// 查询燃气用户详细
export function getInfo(gasUserId) {
  return request({
    url: '/gasUser/info/' + gasUserId,
    method: 'get'
  })
}

// 新增燃气用户
export function addInfo(data) {
  return request({
    url: '/gasUser/info',
    method: 'post',
    data: data
  })
}

// 修改燃气用户
export function updateInfo(data) {
  return request({
    url: '/gasUser/info',
    method: 'put',
    data: data
  })
}

// 删除燃气用户
export function delInfo(gasUserId) {
  return request({
    url: '/gasUser/info/' + gasUserId,
    method: 'delete'
  })
}

// 导出燃气用户
export function exportInfo(query) {
  return request({
    url: '/gasUser/info/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/gasUser/info/importTemplate',
    method: 'get'
  })
}
