import request from '@/utils/request'

// 查询气瓶信息列表
export function listInfo(query) {
  return request({
    url: '/gasBottle/info/list',
    method: 'get',
    params: query
  })
}

export function bottleInfoList(query) {
  return request({
    url: '/gasBottle/info/bottleInfoList',
    method: 'get',
    params: query
  })
}

// 查询气瓶信息详细
export function getInfo(bottleId) {
  return request({
    url: '/gasBottle/info/' + bottleId,
    method: 'get'
  })
}

// 新增气瓶信息
export function addInfo(data) {
  return request({
    url: '/gasBottle/info',
    method: 'post',
    data: data
  })
}

// 修改气瓶信息
export function updateInfo(data) {
  return request({
    url: '/gasBottle/info',
    method: 'put',
    data: data
  })
}

// 删除气瓶信息
export function delInfo(bottleId) {
  return request({
    url: '/gasBottle/info/' + bottleId,
    method: 'delete'
  })
}

// 导出气瓶信息
export function exportInfo(query) {
  return request({
    url: '/gasBottle/info/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/gasBottle/info/importTemplate',
    method: 'get'
  })
}

//气瓶统计
export function bottleStatistics(query) {
  return request({
    url: '/gasBottle/info/bottleStatistics',
    method: 'get',
    params: query
  })
}

//气瓶统计导出
export function bottleStatisticsExport(query) {
  return request({
    url: '/gasBottle/info/bottleStatisticsExport',
    method: 'get',
    params: query
  })
}
