import request from '@/utils/request'

// 查询投诉处置列表
export function listComplainDeal(query) {
  return request({
    url: '/complainDeal/list',
    method: 'get',
    params: query
  })
}

// 查询投诉处置详细
export function getComplainDeal(complainDealId) {
  return request({
    url: '/complainDeal/' + complainDealId,
    method: 'get'
  })
}

// 新增投诉处置
export function addComplainDeal(data) {
  return request({
    url: '/complainDeal',
    method: 'post',
    data: data
  })
}

// 修改投诉处置
export function updateComplainDeal(data) {
  return request({
    url: '/complainDeal',
    method: 'put',
    data: data
  })
}

// 删除投诉处置
export function delComplainDeal(complainDealId) {
  return request({
    url: '/complainDeal/' + complainDealId,
    method: 'delete'
  })
}

// 导出投诉处置
export function exportComplainDeal(query) {
  return request({
    url: '/complainDeal/complainDeal/export',
    method: 'get',
    params: query
  })
}

export function getUserList(cId) {
  return request({
    url: '/complainDeal/getuserList/' + cId,
    method: 'get'
  })
}

export function getComplainDealManSysSet() {
  return request({
    url: '/complainDeal/set/list',
    method: 'get'
  })
}


export function batchUpdateComplainDealManSysSet(data) {
  return request({
    url: '/complainDeal/set/batchUpdate' ,
    method: 'post',
    data: data
  })
}


export function addComplainTransFer(data) {
  return request({
    url: '/complainDeal/transfer' ,
    method: 'post',
    data: data
  })
}


export function listComplainTransFer(complainDealId) {
  return request({
    url: '/complainDeal/transfer/queryByComplainDealId/' + complainDealId ,
    method: 'get'
  })
}

export function addComplainEvaluate(data) {
  return request({
    url: '/complainDeal/evaluate' ,
    method: 'post',
    data: data
  })
}

export function updateComplainEvaluate(data) {
  return request({
    url: '/complainDeal/evaluate' ,
    method: 'put',
    data: data
  })
}

export function getComplainEvaluateByComplainDealId(complainDealId) {
  return request({
    url: '/complainDeal/evaluate/getByComplainDealId/' + complainDealId ,
    method: 'get'
  })
}


export function complainDealSummaryAnalysisMethod() {
  return request({
    url: '/complainDeal/complainDealSummaryAnalysisMethod' ,
    method: 'get'
  })
}


export function complainDealSummaryAnalysisMethodTableViews(query) {
  return request({
    url: '/complainDeal/complainDealSummaryAnalysisMethodTableViews' ,
    method: 'get',
    params: query
  })
}


export function complainDealSummaryAnalysisExport(data) {
    return request({
      url: '/complainDeal/complainDealSummaryAnalysisExport' ,
      method: 'post',
      data: data,
      responseType:'blob'
    })
}

// 根据 投诉 id 和 督办状态查询数据
export function getOverSuperByComplainDealIdAndStatus(query) {
  return request({
    url: '/complainDeal/super/getOverSuperByComplainDealIdAndStatus' ,
    method: 'get',
    params: query
  })
}

// 新增-超时督办
export function addComplainDealOverSuper(data) {
  return request({
    url: '/complainDeal/super' ,
    method: 'post',
    data: data
  })
}

// 修改-超时督办
export function updateComplainDealOverSuper(data) {
  return request({
    url: '/complainDeal/super' ,
    method: 'put',
    data: data
  })
}


// 超时督办 反馈确认
export function overtimeSupervisionFeedbackConfirmationMethod(data) {
  return request({
    url: '/complainDeal/super/overtimeSupervisionFeedbackConfirmation' ,
    method: 'post',
    data: data
  })
}

// 历史督办记录
export function historyOvertimeSupervisionListMethod(query) {
  return request({
    url: '/complainDeal/super/listNoPage' ,
    method: 'get',
    params: query
  })
}