package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TWorkTaskMember;
import com.zehong.system.mapper.TWorkTaskMemberMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkTaskMapper;
import com.zehong.system.domain.TWorkTask;
import com.zehong.system.service.ITWorkTaskService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 巡检巡查任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-14
 */
@Service
public class TWorkTaskServiceImpl implements ITWorkTaskService 
{
    @Autowired
    private TWorkTaskMapper tWorkTaskMapper;

    @Autowired
    private TWorkTaskMemberMapper tWorkTaskMemberMapper;

    /**
     * 查询巡检巡查任务
     * 
     * @param taskId 巡检巡查任务ID
     * @return 巡检巡查任务
     */
    @Override
    public TWorkTask selectTWorkTaskById(Long taskId)
    {
        return tWorkTaskMapper.selectTWorkTaskById(taskId);
    }

    /**
     * 查询巡检巡查任务列表
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 巡检巡查任务
     */
    @Override
    public List<TWorkTask> selectTWorkTaskList(TWorkTask tWorkTask)
    {
        return tWorkTaskMapper.selectTWorkTaskList(tWorkTask);
    }


    /**
     * 新增巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTWorkTask(TWorkTask tWorkTask)
    {
        tWorkTask.setCreateTime(DateUtils.getNowDate());
        if(tWorkTask.getCreateEnterpriseId()==null){
            tWorkTask.setCreateEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
            tWorkTask.setCreateBy("-1");
        }
        int i = tWorkTaskMapper.insertTWorkTask(tWorkTask);
        if(tWorkTask.getPersonIds()!=null){
            for (String str : tWorkTask.getPersonIds()){
                TWorkTaskMember member = new TWorkTaskMember();
                member.setMemberId(Long.parseLong(str));
                member.setTaskId(tWorkTask.getTaskId());
                tWorkTaskMemberMapper.insertTWorkTaskMember(member);
            }
        }else{
            if(!CollectionUtils.isEmpty(tWorkTask.getTaskMemberList())){
                for(TWorkTaskMember member : tWorkTask.getTaskMemberList()){
                    member.setTaskId(tWorkTask.getTaskId());
                    tWorkTaskMemberMapper.insertTWorkTaskMember(member);
                }
            }
        }

        return i;
    }

    /**
     * 修改巡检巡查任务
     * 
     * @param tWorkTask 巡检巡查任务
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateTWorkTask(TWorkTask tWorkTask)
    {
        if(null != tWorkTask.getTaskMemberList() && !CollectionUtils.isEmpty(tWorkTask.getTaskMemberList())){
            tWorkTaskMemberMapper.deleteWorkTaskMemberByTaskId(tWorkTask.getTaskId());
            for(TWorkTaskMember member : tWorkTask.getTaskMemberList()){
                member.setTaskId(tWorkTask.getTaskId());
                tWorkTaskMemberMapper.insertTWorkTaskMember(member);
            }
        }
        return tWorkTaskMapper.updateTWorkTask(tWorkTask);
    }

    /**
     * 批量删除巡检巡查任务
     * 
     * @param taskIds 需要删除的巡检巡查任务ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTWorkTaskByIds(Long[] taskIds)
    {
        for(Long taskId : taskIds){
            tWorkTaskMemberMapper.deleteWorkTaskMemberByTaskId(taskId);
        }
        return tWorkTaskMapper.deleteTWorkTaskByIds(taskIds);
    }

    /**
     * 删除巡检巡查任务信息
     * 
     * @param taskId 巡检巡查任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskById(Long taskId)
    {
        return tWorkTaskMapper.deleteTWorkTaskById(taskId);
    }

    /**
     * 小程序任务列表
     * @param tWorkTask
     * @return
     */
    @Override
    public List<TWorkTask> selectTaskListxiao(TWorkTask tWorkTask)
    {
        return tWorkTaskMapper.selectTaskListxiao(tWorkTask);
    }

    /**
     * 查询执行任务人员
     * @param taskId
     * @return
     */
    @Override
    public Map<String, Object> selectPersonName(Long taskId){
        return tWorkTaskMapper.selectPersonName(taskId);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer addmember(TWorkTask tWorkTask){
        Integer a = tWorkTaskMemberMapper.deleteWorkTaskMemberByTaskId(tWorkTask.getTaskId());
        for (String s : tWorkTask.getPersonIds()){
            TWorkTaskMember member = new TWorkTaskMember();
            member.setMemberId(Long.parseLong(s));
            member.setTaskId(tWorkTask.getTaskId());
            tWorkTaskMemberMapper.insertTWorkTaskMember(member);
        }
        return a;
    }

}
