package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TUserLocation;
import com.zehong.system.domain.TWorkTaskMember;
import com.zehong.system.mapper.TUserLocationMapper;
import com.zehong.system.mapper.TWorkTaskMemberMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkTaskPatrolMapper;
import com.zehong.system.domain.TWorkTaskPatrol;
import com.zehong.system.service.ITWorkTaskPatrolService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 巡线任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-15
 */
@Service
public class TWorkTaskPatrolServiceImpl implements ITWorkTaskPatrolService 
{
    @Autowired
    private TWorkTaskPatrolMapper tWorkTaskPatrolMapper;
    @Autowired
    private TUserLocationMapper tUserLocationMapper;
    @Autowired
    private TWorkTaskMemberMapper tWorkTaskMemberMapper;

    /**
     * 查询巡线任务
     * 
     * @param patrolId 巡线任务ID
     * @return 巡线任务
     */
    @Override
    public TWorkTaskPatrol selectTWorkTaskPatrolById(Long patrolId)
    {
        TWorkTaskPatrol p = tWorkTaskPatrolMapper.selectTWorkTaskPatrolById(patrolId);
        TUserLocation ul = new TUserLocation();
        ul.setBeginTime(p.getCreateTime());
        ul.setEndTime(p.getEndTime());
        ul.setUserId(p.getMemberId());
        List<TUserLocation> list = tUserLocationMapper.selectTUserLocationList(ul);
        p.setLocationList(list);
        return p;
    }

    /**
     * 查询巡线任务列表
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 巡线任务
     */
    @Override
    public List<TWorkTaskPatrol> selectTWorkTaskPatrolList(TWorkTaskPatrol tWorkTaskPatrol)
    {
        return tWorkTaskPatrolMapper.selectTWorkTaskPatrolList(tWorkTaskPatrol);
    }

    /**
     * 新增巡线任务
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTWorkTaskPatrol(TWorkTaskPatrol tWorkTaskPatrol)
    {
        tWorkTaskPatrol.setCreateTime(DateUtils.getNowDate());
        Integer a = tWorkTaskPatrolMapper.insertTWorkTaskPatrol(tWorkTaskPatrol);
        TWorkTaskMember m = new TWorkTaskMember();
        m.setMemberId(tWorkTaskPatrol.getMemberId());
        m.setTaskId(tWorkTaskPatrol.getTaskId());
        m.setProgress(1);
        tWorkTaskMemberMapper.updateByMemberIdTaskId(m);
        return a;
    }

    /**
     * 修改巡线任务
     * 
     * @param tWorkTaskPatrol 巡线任务
     * @return 结果
     */
    @Override
    public int updateTWorkTaskPatrol(TWorkTaskPatrol tWorkTaskPatrol)
    {
        tWorkTaskPatrol.setEndTime(new Date());
        return tWorkTaskPatrolMapper.updateTWorkTaskPatrol(tWorkTaskPatrol);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updatebytmid(TWorkTaskPatrol tWorkTaskPatrol)
    {
        tWorkTaskPatrol.setEndTime(new Date());
        Integer a = tWorkTaskPatrolMapper.updatebytmid(tWorkTaskPatrol);
        TWorkTaskMember m = new TWorkTaskMember();
        m.setMemberId(tWorkTaskPatrol.getMemberId());
        m.setTaskId(tWorkTaskPatrol.getTaskId());
        m.setProgress(0);
        tWorkTaskMemberMapper.updateByMemberIdTaskId(m);
        return a;
    }


    /**
     * 批量删除巡线任务
     * 
     * @param patrolIds 需要删除的巡线任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskPatrolByIds(Long[] patrolIds)
    {
        return tWorkTaskPatrolMapper.deleteTWorkTaskPatrolByIds(patrolIds);
    }

    /**
     * 删除巡线任务信息
     * 
     * @param patrolId 巡线任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskPatrolById(Long patrolId)
    {
        return tWorkTaskPatrolMapper.deleteTWorkTaskPatrolById(patrolId);
    }


    /**
     * 巡检统计
     * @param tWorkTaskPatrol 巡检实体
     * @return
     */
    @Override
    public List<Map<String,Object>> patrolStatistic(TWorkTaskPatrol tWorkTaskPatrol){
        return tWorkTaskPatrolMapper.patrolStatistic(tWorkTaskPatrol);
    }
}
