package com.zehong.system.service.impl;

import com.zehong.system.domain.TVehicleLocationInfo;
import com.zehong.system.mapper.TVehicleLocationInfoMapper;
import com.zehong.system.service.ITVehicleLocationInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 燃气车辆位置信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-03-17
 */
@Service
public class TVehicleLocationInfoServiceImpl implements ITVehicleLocationInfoService
{
    @Autowired
    private TVehicleLocationInfoMapper tVehicleLocationInfoMapper;

    /**
     * 查询燃气车辆位置信息
     * 
     * @param vehicleLocationId 燃气车辆位置信息ID
     * @return 燃气车辆位置信息
     */
    @Override
    public TVehicleLocationInfo selectTVehicleLocationInfoById(Long vehicleLocationId)
    {
        return tVehicleLocationInfoMapper.selectTVehicleLocationInfoById(vehicleLocationId);
    }

    /**
     * 查询燃气车辆位置信息列表
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 燃气车辆位置信息
     */
    @Override
    public List<TVehicleLocationInfo> selectTVehicleLocationInfoList(TVehicleLocationInfo tVehicleLocationInfo)
    {
        return tVehicleLocationInfoMapper.selectTVehicleLocationInfoList(tVehicleLocationInfo);
    }

    /**
     * 新增燃气车辆位置信息
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 结果
     */
    @Override
    public int insertTVehicleLocationInfo(TVehicleLocationInfo tVehicleLocationInfo)
    {
        return tVehicleLocationInfoMapper.insertTVehicleLocationInfo(tVehicleLocationInfo);
    }

    /**
     * 修改燃气车辆位置信息
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 结果
     */
    @Override
    public int updateTVehicleLocationInfo(TVehicleLocationInfo tVehicleLocationInfo)
    {
        return tVehicleLocationInfoMapper.updateTVehicleLocationInfo(tVehicleLocationInfo);
    }

    /**
     * 批量删除燃气车辆位置信息
     * 
     * @param vehicleLocationIds 需要删除的燃气车辆位置信息ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleLocationInfoByIds(Long[] vehicleLocationIds)
    {
        return tVehicleLocationInfoMapper.deleteTVehicleLocationInfoByIds(vehicleLocationIds);
    }

    /**
     * 删除燃气车辆位置信息信息
     * 
     * @param vehicleLocationId 燃气车辆位置信息ID
     * @return 结果
     */
    @Override
    public int deleteTVehicleLocationInfoById(Long vehicleLocationId)
    {
        return tVehicleLocationInfoMapper.deleteTVehicleLocationInfoById(vehicleLocationId);
    }
}
