package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTownLevelRegionMapper;
import com.zehong.system.domain.TTownLevelRegion;
import com.zehong.system.service.ITTownLevelRegionService;

/**
 * 乡级行政区Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-07
 */
@Service
public class TTownLevelRegionServiceImpl implements ITTownLevelRegionService 
{
    @Autowired
    private TTownLevelRegionMapper tTownLevelRegionMapper;

    /**
     * 查询乡级行政区
     * 
     * @param fId 乡级行政区ID
     * @return 乡级行政区
     */
    @Override
    public TTownLevelRegion selectTTownLevelRegionById(Long fId)
    {
        return tTownLevelRegionMapper.selectTTownLevelRegionById(fId);
    }

    /**
     * 查询乡级行政区列表
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 乡级行政区
     */
    @Override
    public List<TTownLevelRegion> selectTTownLevelRegionList(TTownLevelRegion tTownLevelRegion)
    {
        return tTownLevelRegionMapper.selectTTownLevelRegionList(tTownLevelRegion);
    }

    /**
     * 新增乡级行政区
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 结果
     */
    @Override
    public int insertTTownLevelRegion(TTownLevelRegion tTownLevelRegion)
    {
        return tTownLevelRegionMapper.insertTTownLevelRegion(tTownLevelRegion);
    }

    /**
     * 修改乡级行政区
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 结果
     */
    @Override
    public int updateTTownLevelRegion(TTownLevelRegion tTownLevelRegion)
    {
        return tTownLevelRegionMapper.updateTTownLevelRegion(tTownLevelRegion);
    }

    /**
     * 批量删除乡级行政区
     * 
     * @param fIds 需要删除的乡级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTTownLevelRegionByIds(Long[] fIds)
    {
        return tTownLevelRegionMapper.deleteTTownLevelRegionByIds(fIds);
    }

    /**
     * 删除乡级行政区信息
     * 
     * @param fId 乡级行政区ID
     * @return 结果
     */
    @Override
    public int deleteTTownLevelRegionById(Long fId)
    {
        return tTownLevelRegionMapper.deleteTTownLevelRegionById(fId);
    }
}
