package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSuperviseMapper;
import com.zehong.system.domain.TSupervise;
import com.zehong.system.service.ITSuperviseService;

/**
 * 监督检查Service业务层处理
 * 
 * @author zehong
 * @date 2024-02-04
 */
@Service
public class TSuperviseServiceImpl implements ITSuperviseService 
{
    @Autowired
    private TSuperviseMapper tSuperviseMapper;

    /**
     * 查询监督检查
     * 
     * @param id 监督检查ID
     * @return 监督检查
     */
    @Override
    public TSupervise selectTSuperviseById(Long id)
    {
        return tSuperviseMapper.selectTSuperviseById(id);
    }

    /**
     * 查询监督检查列表
     * 
     * @param tSupervise 监督检查
     * @return 监督检查
     */
    @Override
    public List<TSupervise> selectTSuperviseList(TSupervise tSupervise)
    {
        return tSuperviseMapper.selectTSuperviseList(tSupervise);
    }

    /**
     * 新增监督检查
     * 
     * @param tSupervise 监督检查
     * @return 结果
     */
    @Override
    public int insertTSupervise(TSupervise tSupervise)
    {
        tSupervise.setCreateTime(DateUtils.getNowDate());
        return tSuperviseMapper.insertTSupervise(tSupervise);
    }

    /**
     * 修改监督检查
     * 
     * @param tSupervise 监督检查
     * @return 结果
     */
    @Override
    public int updateTSupervise(TSupervise tSupervise)
    {
        return tSuperviseMapper.updateTSupervise(tSupervise);
    }

    /**
     * 批量删除监督检查
     * 
     * @param ids 需要删除的监督检查ID
     * @return 结果
     */
    @Override
    public int deleteTSuperviseByIds(Long[] ids)
    {
        return tSuperviseMapper.deleteTSuperviseByIds(ids);
    }

    /**
     * 删除监督检查信息
     * 
     * @param id 监督检查ID
     * @return 结果
     */
    @Override
    public int deleteTSuperviseById(Long id)
    {
        return tSuperviseMapper.deleteTSuperviseById(id);
    }
}
