package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupMajorHazardMapper;
import com.zehong.system.domain.TSupMajorHazard;
import com.zehong.system.service.ITSupMajorHazardService;

/**
 * 重大危险源监管Service业务层处理
 * 
 * @author zehong
 * @date 2024-04-19
 */
@Service
public class TSupMajorHazardServiceImpl implements ITSupMajorHazardService 
{
    @Autowired
    private TSupMajorHazardMapper tSupMajorHazardMapper;

    /**
     * 查询重大危险源监管
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 重大危险源监管
     */
    @Override
    public TSupMajorHazard selectTSupMajorHazardById(Long fHazardId)
    {
        return tSupMajorHazardMapper.selectTSupMajorHazardById(fHazardId);
    }

    /**
     * 查询重大危险源监管列表
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管
     */
    @Override
    public List<TSupMajorHazard> selectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard)
    {
        return tSupMajorHazardMapper.selectTSupMajorHazardList(tSupMajorHazard);
    }

    /**
     * 导出重大危险源监管列表
     *
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管
     */
    @Override
    public List<TSupMajorHazard> exportselectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard)
    {
        return tSupMajorHazardMapper.exportselectTSupMajorHazardList(tSupMajorHazard);
    }
    /**
     * 新增重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    @Override
    public int insertTSupMajorHazard(TSupMajorHazard tSupMajorHazard)
    {
        return tSupMajorHazardMapper.insertTSupMajorHazard(tSupMajorHazard);
    }

    /**
     * 修改重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    @Override
    public int updateTSupMajorHazard(TSupMajorHazard tSupMajorHazard)
    {
        return tSupMajorHazardMapper.updateTSupMajorHazard(tSupMajorHazard);
    }

    /**
     * 批量删除重大危险源监管
     * 
     * @param fHazardIds 需要删除的重大危险源监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupMajorHazardByIds(Long[] fHazardIds)
    {
        return tSupMajorHazardMapper.deleteTSupMajorHazardByIds(fHazardIds);
    }

    /**
     * 删除重大危险源监管信息
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupMajorHazardById(Long fHazardId)
    {
        return tSupMajorHazardMapper.deleteTSupMajorHazardById(fHazardId);
    }
}
