package com.zehong.system.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.Statistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupBalGasSupMapper;
import com.zehong.system.domain.TSupBalGasSup;
import com.zehong.system.service.ITSupBalGasSupService;

/**
 * 供需平衡-气量监管Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-15
 */
@Service
public class TSupBalGasSupServiceImpl implements ITSupBalGasSupService 
{
    @Autowired
    private TSupBalGasSupMapper tSupBalGasSupMapper;

    /**
     * 查询供需平衡-气量监管
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 供需平衡-气量监管
     */
    @Override
    public TSupBalGasSup selectTSupBalGasSupById(Long fGasSupId)
    {
        return tSupBalGasSupMapper.selectTSupBalGasSupById(fGasSupId);
    }

    /**
     * 查询供需平衡-气量监管列表
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 供需平衡-气量监管
     */
    @Override
    public List<TSupBalGasSup> selectTSupBalGasSupList(TSupBalGasSup tSupBalGasSup)
    {
        return tSupBalGasSupMapper.selectTSupBalGasSupList(tSupBalGasSup);
    }

    @Override
    public List<Statistics> tSupBalGasSupStatistics(List<String> sevenDate)
    {

        String companyInfoId = SecurityUtils.getLoginUser().getUser().getDeptId();
        if (!isQy()) {
            companyInfoId = null;
        }
        return tSupBalGasSupMapper.tSupBalGasSupStatistics(sevenDate,companyInfoId);
    }

    /**
     * 新增供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    @Override
    public int insertTSupBalGasSup(TSupBalGasSup tSupBalGasSup)
    {
        tSupBalGasSup.setCreateTime(DateUtils.getNowDate());
        tSupBalGasSup.setfSupDate(new Date());
        tSupBalGasSup.setfCompanyInfoId(SecurityUtils.getLoginUser().getUser().getDeptId());
        return tSupBalGasSupMapper.insertTSupBalGasSup(tSupBalGasSup);
    }

    /**
     * 修改供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    @Override
    public int updateTSupBalGasSup(TSupBalGasSup tSupBalGasSup)
    {
        tSupBalGasSup.setUpdateTime(DateUtils.getNowDate());
        return tSupBalGasSupMapper.updateTSupBalGasSup(tSupBalGasSup);
    }

    /**
     * 批量删除供需平衡-气量监管
     * 
     * @param fGasSupIds 需要删除的供需平衡-气量监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalGasSupByIds(Long[] fGasSupIds)
    {
        return tSupBalGasSupMapper.deleteTSupBalGasSupByIds(fGasSupIds);
    }

    /**
     * 删除供需平衡-气量监管信息
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalGasSupById(Long fGasSupId)
    {
        return tSupBalGasSupMapper.deleteTSupBalGasSupById(fGasSupId);
    }

     /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
     @Override
     public TSupBalGasSup getReportInfoByCompany(String companyId, String calendarDate){
         Map<String,String> param = new HashMap();
         param.put("companyId",companyId);
         param.put("calendarDate",calendarDate);
         return tSupBalGasSupMapper.getReportInfoByCompany(param);
     }

    /**
     * 上传气量监管记录
     * @param fGasSupId 监管记录主键
     * @return
     */
    @Override
    public int reportSupBalGasSupRecInfo(Long fGasSupId) {
        TSupBalGasSup tSupBalGasSup = new TSupBalGasSup();
        tSupBalGasSup.setfGasSupId(fGasSupId);
        tSupBalGasSup.setfGovUploadTime(new Date());
        tSupBalGasSup.setfGovUploadStatus("1");
        return tSupBalGasSupMapper.updateTSupBalGasSup(tSupBalGasSup);
    }


    /**
     * 判断是否为政府角色
     * @return
     */
    private boolean isQy(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }
}
