package com.zehong.system.service.impl;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TSerialNumberInfo;
import com.zehong.system.mapper.TSerialNumberInfoMapper;
import com.zehong.system.service.ITSerialNumberInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 序列号Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-07
 */
@Service
public class TSerialNumberInfoServiceImpl implements ITSerialNumberInfoService 
{
    @Autowired
    private TSerialNumberInfoMapper tSerialNumberInfoMapper;

    /**
     * 查询序列号
     * 
     * @param numberId 序列号ID
     * @return 序列号
     */
    @Override
    public TSerialNumberInfo selectTSerialNumberInfoById(Long numberId)
    {
        return tSerialNumberInfoMapper.selectTSerialNumberInfoById(numberId);
    }

    /**
     * 查询序列号列表
     * 
     * @param tSerialNumberInfo 序列号
     * @return 序列号
     */
    @Override
    public List<TSerialNumberInfo> selectTSerialNumberInfoList(TSerialNumberInfo tSerialNumberInfo)
    {
        return tSerialNumberInfoMapper.selectTSerialNumberInfoList(tSerialNumberInfo);
    }

    /**
     * 新增序列号
     * 
     * @param tSerialNumberInfo 序列号
     * @return 结果
     */
    @Override
    public int insertTSerialNumberInfo(TSerialNumberInfo tSerialNumberInfo)
    {
        return tSerialNumberInfoMapper.insertTSerialNumberInfo(tSerialNumberInfo);
    }

    /**
     * 修改序列号
     * 
     * @param tSerialNumberInfo 序列号
     * @return 结果
     */
    @Override
    public int updateTSerialNumberInfo(TSerialNumberInfo tSerialNumberInfo)
    {
        tSerialNumberInfo.setUpdateTime(DateUtils.getNowDate());
        return tSerialNumberInfoMapper.updateTSerialNumberInfo(tSerialNumberInfo);
    }

    /**
     * 批量删除序列号
     * 
     * @param numberIds 需要删除的序列号ID
     * @return 结果
     */
    @Override
    public int deleteTSerialNumberInfoByIds(Long[] numberIds)
    {
        return tSerialNumberInfoMapper.deleteTSerialNumberInfoByIds(numberIds);
    }

    /**
     * 删除序列号信息
     * 
     * @param numberId 序列号ID
     * @return 结果
     */
    @Override
    public int deleteTSerialNumberInfoById(Long numberId)
    {
        return tSerialNumberInfoMapper.deleteTSerialNumberInfoById(numberId);
    }

    /**
     * 根据表类型获取序列号
     * @param tableType 表表类型
     * @return
     */
    @Override
    public synchronized Map<String,String> getSerialNumberByTableType(String tableType){
        //获取最新编号
        TSerialNumberInfo tSerialNumberInfo = new TSerialNumberInfo();
        tSerialNumberInfo.setTableType(tableType);
        List<TSerialNumberInfo> serialNumberInfoList = tSerialNumberInfoMapper.selectTSerialNumberInfoList(tSerialNumberInfo);
        Map<String,String> numberMap = new HashMap<>();
        //更新编号
        serialNumberInfoList.stream().forEach(item ->{
            //自旋更新
            int result;
            int lookNum = 0;
            do{
                lookNum ++;
                Long maxNum = item.getMaxNum();
                maxNum++;
                maxNum = maxNum.toString().length() > item.getNumLength() ? 0 : maxNum;
                String number = String.format("%0"+ item.getNumLength() +"d",maxNum);
                numberMap.put(item.getColumnName(),number);
                item.setMaxNum(maxNum);
                result = tSerialNumberInfoMapper.updateTSerialNumberInfo(item);
                if(result == 0) item = tSerialNumberInfoMapper.selectTSerialNumberInfoById(item.getNumberId());
            }while (result == 0 && lookNum < 5);
            if(lookNum > 4) throw new CustomException("序列号生成失败");
        });
        return numberMap;
    }

}
