package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TSafeCheckRecord;
import com.zehong.system.mapper.TSafeCheckRecordMapper;
import com.zehong.system.service.ITSafeCheckRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 安检记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-08-21
 */
@Service
public class TSafeCheckRecordServiceImpl implements ITSafeCheckRecordService
{
    @Autowired
    private TSafeCheckRecordMapper tSafeCheckRecordMapper;

    /**
     * 查询安检记录
     * 
     * @param safeCheckId 安检记录ID
     * @return 安检记录
     */
    @Override
    public TSafeCheckRecord selectTSafeCheckRecordById(Long safeCheckId)
    {
        return tSafeCheckRecordMapper.selectTSafeCheckRecordById(safeCheckId);
    }

    /**
     * 查询安检记录列表
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 安检记录
     */
    @Override
    public List<TSafeCheckRecord> selectTSafeCheckRecordList(TSafeCheckRecord tSafeCheckRecord)
    {
        return tSafeCheckRecordMapper.selectTSafeCheckRecordList(tSafeCheckRecord);
    }

    /**
     * 新增安检记录
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 结果
     */
    @Override
    public int insertTSafeCheckRecord(TSafeCheckRecord tSafeCheckRecord)
    {
        tSafeCheckRecord.setCreateTime(DateUtils.getNowDate());
        return tSafeCheckRecordMapper.insertTSafeCheckRecord(tSafeCheckRecord);
    }

    /**
     * 修改安检记录
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 结果
     */
    @Override
    public int updateTSafeCheckRecord(TSafeCheckRecord tSafeCheckRecord)
    {
        tSafeCheckRecord.setUpdateTime(DateUtils.getNowDate());
        return tSafeCheckRecordMapper.updateTSafeCheckRecord(tSafeCheckRecord);
    }

    /**
     * 批量删除安检记录
     * 
     * @param safeCheckIds 需要删除的安检记录ID
     * @return 结果
     */
    @Override
    public int deleteTSafeCheckRecordByIds(Long[] safeCheckIds)
    {
        return tSafeCheckRecordMapper.deleteTSafeCheckRecordByIds(safeCheckIds);
    }

    /**
     * 删除安检记录信息
     * 
     * @param safeCheckId 安检记录ID
     * @return 结果
     */
    @Override
    public int deleteTSafeCheckRecordById(Long safeCheckId)
    {
        return tSafeCheckRecordMapper.deleteTSafeCheckRecordById(safeCheckId);
    }
}
