package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.*;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.utils.uuid.IdUtils;
import com.zehong.system.domain.TPipeOldPlanProcess;
import com.zehong.system.domain.vo.TPipeOldPlanProcessVo;
import com.zehong.system.mapper.TPipeOldPlanProcessMapper;
import com.zehong.system.service.ITPipeOldPlanProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 老旧管网-改造计划和进度Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-15
 */
@Service
public class TPipeOldPlanProcessServiceImpl implements ITPipeOldPlanProcessService 
{
    private static final Logger log = LoggerFactory.getLogger(TPipeOldPlanProcessServiceImpl.class);

    @Resource
    private TPipeOldPlanProcessMapper tPipeOldPlanProcessMapper;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 老旧管网-改造计划和进度
     */
    @Override
    public TPipeOldPlanProcess selectTPipeOldPlanProcessById(Long fOldPlanProcessId)
    {
        return tPipeOldPlanProcessMapper.selectTPipeOldPlanProcessById(fOldPlanProcessId);
    }

    /**
     * 查询老旧管网-改造计划和进度列表
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 老旧管网-改造计划和进度
     */
    @Override
    public List<TPipeOldPlanProcess> selectTPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        return tPipeOldPlanProcessMapper.selectTPipeOldPlanProcessList(tPipeOldPlanProcess);
    }

    /**
     * 查询老旧管网-改造计划和进度列表 - 导出时使用
     *
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 老旧管网-改造计划和进度
     */
    @Override
    public List<TPipeOldPlanProcess> exportTPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess) {

        LoginUser loginUser = SecurityUtils.getLoginUser();

        // 如果是 政府端 则 把 govUploadState 赋值给 fUploadType, 把 govUploadTime 赋值给 fUploadTime
        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tPipeOldPlanProcess.setfUploadType("1");
        }
        List<TPipeOldPlanProcess> tPipeOldPlanProcesses = tPipeOldPlanProcessMapper.exportPipeOldPlanProcessList(tPipeOldPlanProcess);

        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            ExcelUtil.hiddencolumns.add(13);
            ExcelUtil.hiddencolumns.add(14);
        }

        if (loginUser.getUser().getRoles().get(0).getRoleId()==5) {
            ExcelUtil.hiddencolumns.add(15);
            ExcelUtil.hiddencolumns.add(16);
        }

        return tPipeOldPlanProcesses;
    }

    /**
     * 新增老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    @Override
    public int insertTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        tPipeOldPlanProcess.setfUuid(IdUtils.fastSimpleUUID());
        tPipeOldPlanProcess.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tPipeOldPlanProcessMapper.insertTPipeOldPlanProcess(tPipeOldPlanProcess);
    }

    /**
     * 修改老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    @Override
    public int updateTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        tPipeOldPlanProcess.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tPipeOldPlanProcessMapper.updateTPipeOldPlanProcess(tPipeOldPlanProcess);
    }

    /**
     * 批量删除老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessIds 需要删除的老旧管网-改造计划和进度ID
     * @return 结果
     */
    @Override
    public int deleteTPipeOldPlanProcessByIds(Long[] fOldPlanProcessIds)
    {
        return tPipeOldPlanProcessMapper.deleteTPipeOldPlanProcessByIds(fOldPlanProcessIds);
    }

    /**
     * 删除老旧管网-改造计划和进度信息
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 结果
     */
    @Override
    public int deleteTPipeOldPlanProcessById(Long fOldPlanProcessId)
    {
        return tPipeOldPlanProcessMapper.deleteTPipeOldPlanProcessById(fOldPlanProcessId);
    }

    @Override
    public int reportPipeOldPlanProcess(Long fOldPlanProcessId) throws Exception {
        TPipeOldPlanProcess tPipeOldPlanProcess = tPipeOldPlanProcessMapper.selectTPipeOldPlanProcessById(fOldPlanProcessId);
        TPipeOldPlanProcessVo pipeOldPlanProcessVo = new TPipeOldPlanProcessVo();
        GovernmentDataCopyUtil.copyToGovernData(tPipeOldPlanProcess,pipeOldPlanProcessVo);
        List<TPipeOldPlanProcessVo> data = new ArrayList<>();
        JSONObject reportResult = governmentDataUtil.setInfo("pipeline/old/plan/process","WRITE",data);
        log.info("上传计划和进度结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("上传计划和进度接口失败");
        tPipeOldPlanProcess.setGovUploadState("1");
        tPipeOldPlanProcess.setGovUploadTime(new Date());
        tPipeOldPlanProcessMapper.updateTPipeOldPlanProcess(tPipeOldPlanProcess);
        return 1;
    }

    /**
     * 企业端上传数据
     * @param fOldPlanProcessId f
     * @return r
     */
    @Override
    public int entReportPipeOldPlanProcess(Long fOldPlanProcessId) {
        String s = DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM_SS, new Date());
        tPipeOldPlanProcessMapper.entReportPipeOldPlanProcess("1",s,fOldPlanProcessId);
        return 1;
    }
}
