package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgVehicleInfoMapper;
import com.zehong.system.domain.TLpgVehicleInfo;
import com.zehong.system.service.ITLpgVehicleInfoService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油车辆信息Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-19
 */
@Service
public class TLpgVehicleInfoServiceImpl implements ITLpgVehicleInfoService 
{
    @Resource
    private TLpgVehicleInfoMapper tLpgVehicleInfoMapper;

    @Resource
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询液化石油车辆信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 液化石油车辆信息
     */
    @Override
    public TLpgVehicleInfo selectTLpgVehicleInfoById(Long vehicleId)
    {
        return tLpgVehicleInfoMapper.selectTLpgVehicleInfoById(vehicleId);
    }

    /**
     * 查询液化石油车辆信息列表
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 液化石油车辆信息
     */
    @Override
    public List<TLpgVehicleInfo> selectTLpgVehicleInfoList(TLpgVehicleInfo tLpgVehicleInfo)
    {
        return tLpgVehicleInfoMapper.selectTLpgVehicleInfoList(tLpgVehicleInfo);
    }

    /**
     * 查询这个企业下车牌号是否重复
     * @param carNums c
     * @param enterpriseId e
     * @return r
     */
    @Override
    public List<TLpgVehicleInfo> queryByCarNumsAndEnterpriseId(List<String> carNums, String enterpriseId) {
        return tLpgVehicleInfoMapper.queryByCarNumsAndEnterpriseId(carNums,enterpriseId);
    }

    /**
     * 新增液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    @Override
    public int insertTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo)
    {
        return tLpgVehicleInfoMapper.insertTLpgVehicleInfo(tLpgVehicleInfo);
    }

    /**
     * 修改液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    @Override
    public int updateTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo)
    {
        return tLpgVehicleInfoMapper.updateTLpgVehicleInfo(tLpgVehicleInfo);
    }

    /**
     * 批量插入
     * @param list list
     * @return r
     */
    @Override
    public int insertBatch(List<TLpgVehicleInfo> list) {
        return tLpgVehicleInfoMapper.insertBatch(list);
    }

    /**
     * 批量更新
     * @param list list
     * @return r
     */
    @Override
    public int updateBatch(List<TLpgVehicleInfo> list) {
        return tLpgVehicleInfoMapper.updateBatch(list);
    }

    /**
     * 批量删除液化石油车辆信息
     * 
     * @param vehicleIds 需要删除的液化石油车辆信息ID
     * @return 结果
     */
    @Override
    public int deleteTLpgVehicleInfoByIds(Long[] vehicleIds)
    {
        return tLpgVehicleInfoMapper.deleteTLpgVehicleInfoByIds(vehicleIds);
    }

    /**
     * 删除液化石油车辆信息信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 结果
     */
    @Override
    public int deleteTLpgVehicleInfoById(Long vehicleId)
    {
        return tLpgVehicleInfoMapper.deleteTLpgVehicleInfoById(vehicleId);
    }

    /**
     * 导入
     * @param XmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    @Override
    public AjaxResult importLpgSafeCheckRecordInfo(List<TLpgVehicleInfo> XmbhList, boolean updateSupport, HttpServletResponse response) {

        int successNum = 0;
        int errorNum = 0;

        if(XmbhList.size() > 0) {
            List<TLpgVehicleInfo> successDataList = new ArrayList<>();
            // 2024-09-14 加上企业信息
            List<TLpgVehicleInfo> collect = XmbhList.stream().filter(item -> StringUtils.isNotBlank(item.getEnterpriseName()) && StringUtils.isNotBlank(item.getCarNum())).collect(Collectors.toList());

            errorNum += (XmbhList.size() - collect.size());

            List<String> collect1 = collect.stream().map(TLpgVehicleInfo::getEnterpriseName).collect(Collectors.toList());
            List<TEnterpriseInfo> tEnterpriseInfos = tEnterpriseInfoMapper.queryAllByEnterpriseNameList(collect1);
            // 按照企业名称分组
            Map<String, List<TEnterpriseInfo>> collect2 = tEnterpriseInfos.stream().collect(Collectors.groupingBy(TEnterpriseInfo::getEnterpriseName));

            for (TLpgVehicleInfo tLpgVehicleInfo : collect) {
                List<TEnterpriseInfo> tEnterpriseInfos1 = collect2.get(tLpgVehicleInfo.getEnterpriseName());
                if (tEnterpriseInfos1 != null && tEnterpriseInfos1.size() > 0) {
                    tLpgVehicleInfo.setEnterpriseId(tEnterpriseInfos1.get(0).getEnterpriseId());
                    successDataList.add(tLpgVehicleInfo);
                    successNum++;
                } else {
                    errorNum++;
                }
            }

            if (successDataList.size() > 0) {
                tLpgVehicleInfoMapper.insertBatch(successDataList);
            }
        }

        HashMap<String,Object> map = new HashMap<>();
        map.put("successNum",successNum);
        map.put("errorNum",errorNum);

        return AjaxResult.success(map);
    }
}
