package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgThirdPartyDockingInterfaceRecordMapper;
import com.zehong.system.domain.TLpgThirdPartyDockingInterfaceRecord;
import com.zehong.system.service.ITLpgThirdPartyDockingInterfaceRecordService;

import javax.annotation.Resource;

/**
 * 液化气第三方对接接口记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-09-18
 */
@Service
public class TLpgThirdPartyDockingInterfaceRecordServiceImpl implements ITLpgThirdPartyDockingInterfaceRecordService 
{
    @Resource
    private TLpgThirdPartyDockingInterfaceRecordMapper tLpgThirdPartyDockingInterfaceRecordMapper;

    /**
     * 查询液化气第三方对接接口记录
     * 
     * @param recordId 液化气第三方对接接口记录ID
     * @return 液化气第三方对接接口记录
     */
    @Override
    public TLpgThirdPartyDockingInterfaceRecord selectTLpgThirdPartyDockingInterfaceRecordById(Long recordId)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.selectTLpgThirdPartyDockingInterfaceRecordById(recordId);
    }

    /**
     * 查询液化气第三方对接接口记录列表
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 液化气第三方对接接口记录
     */
    @Override
    public List<TLpgThirdPartyDockingInterfaceRecord> selectTLpgThirdPartyDockingInterfaceRecordList(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.selectTLpgThirdPartyDockingInterfaceRecordList(tLpgThirdPartyDockingInterfaceRecord);
    }

    /**
     * 新增液化气第三方对接接口记录
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 结果
     */
    @Override
    public int insertTLpgThirdPartyDockingInterfaceRecord(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.insertTLpgThirdPartyDockingInterfaceRecord(tLpgThirdPartyDockingInterfaceRecord);
    }

    /**
     * 批量插入
     * @param list list
     * @return r
     */
    @Override
    public int insertBatch(List<TLpgThirdPartyDockingInterfaceRecord> list) {
        return tLpgThirdPartyDockingInterfaceRecordMapper.insertBatch(list);
    }

    /**
     * 修改液化气第三方对接接口记录
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 结果
     */
    @Override
    public int updateTLpgThirdPartyDockingInterfaceRecord(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.updateTLpgThirdPartyDockingInterfaceRecord(tLpgThirdPartyDockingInterfaceRecord);
    }

    /**
     * 批量删除液化气第三方对接接口记录
     * 
     * @param recordIds 需要删除的液化气第三方对接接口记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgThirdPartyDockingInterfaceRecordByIds(Long[] recordIds)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.deleteTLpgThirdPartyDockingInterfaceRecordByIds(recordIds);
    }

    /**
     * 删除液化气第三方对接接口记录信息
     * 
     * @param recordId 液化气第三方对接接口记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgThirdPartyDockingInterfaceRecordById(Long recordId)
    {
        return tLpgThirdPartyDockingInterfaceRecordMapper.deleteTLpgThirdPartyDockingInterfaceRecordById(recordId);
    }
}
