package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TLpgGasBottleFiles;
import com.zehong.system.domain.TYehuaqiUser;
import com.zehong.system.domain.vo.TLpgDeliveryRecordImportVo;
import com.zehong.system.mapper.TLpgGasBottleFilesMapper;
import com.zehong.system.mapper.TYehuaqiUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLpgDeliveryRecordMapper;
import com.zehong.system.domain.TLpgDeliveryRecord;
import com.zehong.system.service.ITLpgDeliveryRecordService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油配送记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-22
 */
@Service
public class TLpgDeliveryRecordServiceImpl implements ITLpgDeliveryRecordService 
{
    @Resource
    private TLpgDeliveryRecordMapper tLpgDeliveryRecordMapper;

    @Resource
    private TYehuaqiUserMapper yehuaqiUserMapper;

    /**
     * 气瓶档案
     */
    @Resource
    private TLpgGasBottleFilesMapper tLpgGasBottleFilesMapper;
    /**
     * 查询液化石油配送记录
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 液化石油配送记录
     */
    @Override
    public TLpgDeliveryRecord selectTLpgDeliveryRecordById(Long deliveryRecordId)
    {
        return tLpgDeliveryRecordMapper.selectTLpgDeliveryRecordById(deliveryRecordId);
    }

    /**
     * 数据导入
     * @param XmbhList 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param deptId 操作用户
     * @param response r
     * @return r
     */
    @Override
    public HashMap<String,Object> importLpgDelivertyRecordInfo(List<TLpgDeliveryRecordImportVo> XmbhList, Boolean isUpdateSupport, String deptId, HttpServletResponse response) {

        int errorNum = 0;
        int successNum = 0;

        List<TLpgDeliveryRecord> successData = new ArrayList<>();

        TLpgDeliveryRecord lpgDeliveryRecord;
        for (TLpgDeliveryRecordImportVo tLpgDeliveryRecordImportVo : XmbhList) {
            lpgDeliveryRecord = new TLpgDeliveryRecord();

            // 气瓶条码不许为空
            if (StringUtils.isBlank(tLpgDeliveryRecordImportVo.getBottleCode())) {
                errorNum++;
                continue;
            }

            // 如果都为空 则 返回  2024-09-14 如果没有 userOwnId的话，也可以入库。
            if (StringUtils.isBlank(tLpgDeliveryRecordImportVo.getNickName())
            && StringUtils.isBlank(tLpgDeliveryRecordImportVo.getPhone())
            && StringUtils.isBlank(tLpgDeliveryRecordImportVo.getAddress())
            && StringUtils.isBlank(tLpgDeliveryRecordImportVo.getUserOwnId())) {
                errorNum ++;
                continue;
            }

            // 气瓶条码处理
            TLpgGasBottleFiles tLpgGasBottleFiles = new TLpgGasBottleFiles();
            tLpgGasBottleFiles.setQrcode(tLpgDeliveryRecordImportVo.getBottleCode());
            List<TLpgGasBottleFiles> tLpgGasBottleFiles1 = tLpgGasBottleFilesMapper.selectTLpgGasBottleFilesList(tLpgGasBottleFiles);
            if (tLpgGasBottleFiles1 == null || tLpgGasBottleFiles1.size() == 0) {
                errorNum ++;
                continue;
            }
            lpgDeliveryRecord.setBottleCode(tLpgGasBottleFiles1.get(0).getQrcode());


            // 燃气用户处理
            if (StringUtils.isNotBlank(tLpgDeliveryRecordImportVo.getUserOwnId())) {

                TYehuaqiUser yehuaqiUser = yehuaqiUserMapper.selectByUserOwnIdAndBeyondEnterpriseId(deptId, tLpgDeliveryRecordImportVo.getUserOwnId());

                if (yehuaqiUser == null) {
                    errorNum++;
                    continue;
                } else {
                    lpgDeliveryRecord.setUserId(yehuaqiUser.getUserId());
                }
            }

            lpgDeliveryRecord.setStationName(tLpgDeliveryRecordImportVo.getStationName());
            lpgDeliveryRecord.setBottleCode(tLpgDeliveryRecordImportVo.getBottleCode());
            lpgDeliveryRecord.setDeliveryPerson(tLpgDeliveryRecordImportVo.getDeliveryPerson());
            lpgDeliveryRecord.setVehicleCode(tLpgDeliveryRecordImportVo.getVehicleCode());
            lpgDeliveryRecord.setGasUserType(tLpgDeliveryRecordImportVo.getGasUserType());
            lpgDeliveryRecord.setDeliveryAddress(tLpgDeliveryRecordImportVo.getDeliveryAddress());
            lpgDeliveryRecord.setDeliveryDate(tLpgDeliveryRecordImportVo.getDeliveryDate());

            successData.add(lpgDeliveryRecord);
            successNum++;
        }

        if (successData.size() > 0) {
            tLpgDeliveryRecordMapper.insertBatch(successData);
        }
        HashMap<String,Object> map = new HashMap<>();
        map.put("successNum",successNum);
        map.put("errorNum",errorNum);

        return map;
    }

    /**
     * 查询液化石油配送记录列表
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 液化石油配送记录
     */
    @Override
    public List<TLpgDeliveryRecord> selectTLpgDeliveryRecordList(TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        return tLpgDeliveryRecordMapper.selectTLpgDeliveryRecordList(tLpgDeliveryRecord);
    }

    /**
     * 新增液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    @Override
    public int insertTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        tLpgDeliveryRecord.setCreateTime(DateUtils.getNowDate());
        return tLpgDeliveryRecordMapper.insertTLpgDeliveryRecord(tLpgDeliveryRecord);
    }

    @Override
    public int insertBatch(List<TLpgDeliveryRecord> tLpgDeliveryRecords) {
        return tLpgDeliveryRecordMapper.insertBatch(tLpgDeliveryRecords);
    }

    /**
     * 修改液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    @Override
    public int updateTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        tLpgDeliveryRecord.setUpdateTime(DateUtils.getNowDate());
        return tLpgDeliveryRecordMapper.updateTLpgDeliveryRecord(tLpgDeliveryRecord);
    }

    /**
     * 批量删除液化石油配送记录
     * 
     * @param deliveryRecordIds 需要删除的液化石油配送记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgDeliveryRecordByIds(Long[] deliveryRecordIds)
    {
        return tLpgDeliveryRecordMapper.deleteTLpgDeliveryRecordByIds(deliveryRecordIds);
    }

    /**
     * 删除液化石油配送记录信息
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 结果
     */
    @Override
    public int deleteTLpgDeliveryRecordById(Long deliveryRecordId)
    {
        return tLpgDeliveryRecordMapper.deleteTLpgDeliveryRecordById(deliveryRecordId);
    }
}
