package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsStaInforMapper;
import com.zehong.system.domain.TInsStaInfor;
import com.zehong.system.service.ITInsStaInforService;

/**
 * 监督检查-隐患分类分级标准Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-17
 */
@Service
public class TInsStaInforServiceImpl implements ITInsStaInforService 
{
    @Autowired
    private TInsStaInforMapper tInsStaInforMapper;

    /**
     * 查询监督检查-隐患分类分级标准
     * 
     * @param fInsStaInforId 监督检查-隐患分类分级标准ID
     * @return 监督检查-隐患分类分级标准
     */
    @Override
    public TInsStaInfor selectTInsStaInforById(Long fInsStaInforId)
    {
        return tInsStaInforMapper.selectTInsStaInforById(fInsStaInforId);
    }

    /**
     * 查询监督检查-隐患分类分级标准列表
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 监督检查-隐患分类分级标准
     */
    @Override
    public List<TInsStaInfor> selectTInsStaInforList(TInsStaInfor tInsStaInfor)
    {
        return tInsStaInforMapper.selectTInsStaInforList(tInsStaInfor);
    }

    /**
     * 新增监督检查-隐患分类分级标准
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 结果
     */
    @Override
    public int insertTInsStaInfor(TInsStaInfor tInsStaInfor)
    {
        tInsStaInfor.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        tInsStaInfor.setfCreateBy(SecurityUtils.getUsername());
        return tInsStaInforMapper.insertTInsStaInfor(tInsStaInfor);
    }

    /**
     * 修改监督检查-隐患分类分级标准
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 结果
     */
    @Override
    public int updateTInsStaInfor(TInsStaInfor tInsStaInfor)
    {
        tInsStaInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        tInsStaInfor.setfUpdateBy(SecurityUtils.getUsername());
        return tInsStaInforMapper.updateTInsStaInfor(tInsStaInfor);
    }

    /**
     * 批量删除监督检查-隐患分类分级标准
     * 
     * @param fInsStaInforIds 需要删除的监督检查-隐患分类分级标准ID
     * @return 结果
     */
    @Override
    public int deleteTInsStaInforByIds(Long[] fInsStaInforIds)
    {
        return tInsStaInforMapper.deleteTInsStaInforByIds(fInsStaInforIds);
    }

    /**
     * 删除监督检查-隐患分类分级标准信息
     * 
     * @param fInsStaInforId 监督检查-隐患分类分级标准ID
     * @return 结果
     */
    @Override
    public int deleteTInsStaInforById(Long fInsStaInforId)
    {
        return tInsStaInforMapper.deleteTInsStaInforById(fInsStaInforId);
    }
}
