package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.system.domain.TInsSpotRecInfor;
import com.zehong.system.domain.vo.TInsSpotRecInforVo;
import com.zehong.system.mapper.TInsSpotRecInforMapper;
import com.zehong.system.service.ITInsSpotRecInforService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 监督检查-调查结果Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-22
 */
@Service
public class TInsSpotRecInforServiceImpl implements ITInsSpotRecInforService 
{
    private static final Logger log = LoggerFactory.getLogger(TInsSpotRecInforServiceImpl.class);

    @Autowired
    private TInsSpotRecInforMapper tInsSpotRecInforMapper;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询监督检查-调查结果
     * 
     * @param fInsSpotRecInforId 监督检查-调查结果ID
     * @return 监督检查-调查结果
     */
    @Override
    public TInsSpotRecInfor selectTInsSpotRecInforById(Long fInsSpotRecInforId)
    {
        return tInsSpotRecInforMapper.selectTInsSpotRecInforById(fInsSpotRecInforId);
    }

    /**
     * 查询监督检查-调查结果列表
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 监督检查-调查结果
     */
    @Override
    public List<TInsSpotRecInfor> selectTInsSpotRecInforList(TInsSpotRecInfor tInsSpotRecInfor)
    {
        return tInsSpotRecInforMapper.selectTInsSpotRecInforList(tInsSpotRecInfor);
    }

    /**
     * 新增监督检查-调查结果
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 结果
     */
    @Override
    public int insertTInsSpotRecInfor(TInsSpotRecInfor tInsSpotRecInfor)
    {
        tInsSpotRecInfor.setfUpdateTime(new Date());
        return tInsSpotRecInforMapper.insertTInsSpotRecInfor(tInsSpotRecInfor);
    }

    /**
     * 修改监督检查-调查结果
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 结果
     */
    @Override
    public int updateTInsSpotRecInfor(TInsSpotRecInfor tInsSpotRecInfor)
    {
        tInsSpotRecInfor.setfUpdateTime(new Date());
        return tInsSpotRecInforMapper.updateTInsSpotRecInfor(tInsSpotRecInfor);
    }

    /**
     * 批量删除监督检查-调查结果
     * 
     * @param fInsSpotRecInforIds 需要删除的监督检查-调查结果ID
     * @return 结果
     */
    @Override
    public int deleteTInsSpotRecInforByIds(Long[] fInsSpotRecInforIds)
    {
        return tInsSpotRecInforMapper.deleteTInsSpotRecInforByIds(fInsSpotRecInforIds);
    }

    /**
     * 删除监督检查-调查结果信息
     * 
     * @param fInsSpotRecInforId 监督检查-调查结果ID
     * @return 结果
     */
    @Override
    public int deleteTInsSpotRecInforById(Long fInsSpotRecInforId)
    {
        return tInsSpotRecInforMapper.deleteTInsSpotRecInforById(fInsSpotRecInforId);
    }

    /**
     * 上传调查结果
     * @param fInsSpotRecInforId 调查结果id
     * @return
     */
    @Override
    public int reportSpotRecInfo(Long fInsSpotRecInforId) throws Exception {
        TInsSpotRecInfor insSpotRecInfor = tInsSpotRecInforMapper.selectTInsSpotRecInforById(fInsSpotRecInforId);
        TInsSpotRecInforVo insSpotRecInforVo = new TInsSpotRecInforVo();
        GovernmentDataCopyUtil.copyToGovernData(insSpotRecInfor,insSpotRecInforVo);
        List<TInsSpotRecInforVo> data = new ArrayList<>();
        data.add(insSpotRecInforVo);
        JSONObject reportResult = governmentDataUtil.setInfo("inspection/record/information","WRITE",data);
        log.info("上传调查结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("上传调查结果市局接口失败");
        insSpotRecInfor.setGovUploadState("1");
        insSpotRecInfor.setGovUploadTime(new Date());
        int i = tInsSpotRecInforMapper.updateTInsSpotRecInfor(insSpotRecInfor);
        if(i == 0) throw new CustomException("调研结果上传状态更新失败");
        return 1;
    }
}
