package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.form.THiddenDangerStandingBookForm;
import com.zehong.system.domain.vo.THiddenDangerStandingBookVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.THiddenDangerStandingBookMapper;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.service.ITHiddenDangerStandingBookService;

/**
 * 隐患整治台账Service业务层处理
 *
 * @author zehong
 * @date 2022-02-09
 */
@Service
public class THiddenDangerStandingBookServiceImpl implements ITHiddenDangerStandingBookService
{
    @Autowired
    private THiddenDangerStandingBookMapper tHiddenDangerStandingBookMapper;

    /**
     * 查询隐患整治台账
     *
     * @param hiddenId 隐患整治台账ID
     * @return 隐患整治台账
     */
    @Override
    public THiddenDangerStandingBook selectTHiddenDangerStandingBookById(Long hiddenId)
    {
        return tHiddenDangerStandingBookMapper.selectTHiddenDangerStandingBookById(hiddenId);
    }

    /**
     * 查询隐患整治台账列表
     *
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 隐患整治台账
     */
    @Override
    public List<THiddenDangerStandingBook> selectTHiddenDangerStandingBookList(THiddenDangerStandingBookForm tHiddenDangerStandingBook)
    {
        // 20240726 调整 政府和企业都可以录，企业看自己，政府看所有
        if (isEnterprise() && tHiddenDangerStandingBook != null) {
            tHiddenDangerStandingBook.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        return tHiddenDangerStandingBookMapper.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);
    }

    /**
     *  隐患台账统计
     *
     * @return 隐患整治台账集合
     */
    public THiddenDangerStandingBookVo selectTHiddenDangerStandingBookStatistic()
    {
        return tHiddenDangerStandingBookMapper.selectTHiddenDangerStandingBookStatistic();
    }

    /**
     * 新增隐患整治台账
     *
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 结果
     */
    @Override
    public int insertTHiddenDangerStandingBook(THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        tHiddenDangerStandingBook.setCreateTime(DateUtils.getNowDate());
        return tHiddenDangerStandingBookMapper.insertTHiddenDangerStandingBook(tHiddenDangerStandingBook);
    }

    /**
     * 修改隐患整治台账
     *
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 结果
     */
    @Override
    public int updateTHiddenDangerStandingBook(THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        tHiddenDangerStandingBook.setUpdateTime(DateUtils.getNowDate());
        return tHiddenDangerStandingBookMapper.updateTHiddenDangerStandingBook(tHiddenDangerStandingBook);
    }

    /**
     * 批量删除隐患整治台账
     *
     * @param hiddenIds 需要删除的隐患整治台账ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenDangerStandingBookByIds(Long[] hiddenIds)
    {
        return tHiddenDangerStandingBookMapper.deleteTHiddenDangerStandingBookByIds(hiddenIds);
    }

    /**
     * 删除隐患整治台账信息
     *
     * @param hiddenId 隐患整治台账ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenDangerStandingBookById(Long hiddenId)
    {
        return tHiddenDangerStandingBookMapper.deleteTHiddenDangerStandingBookById(hiddenId);
    }

    /**
     * 获取隐患整治台账统计信息
     * @param sevenDate
     * @return
     */
    @Override
    public List<Statistics> hazardStatistics(List<String> sevenDate) {
        return tHiddenDangerStandingBookMapper.hazardStatistics(sevenDate);
    }

    /**
     * 统计隐患数量
     * @return
     */
    @Override
    public List<Map<String,Object>> selectCountByMonth() {
        return tHiddenDangerStandingBookMapper.selectCountByMonth();
    }
    /**
     * 统计每年隐患数量
     * @return
     */
    @Override
    public List<Map<String,Object>> selectCountByYear() {
        return tHiddenDangerStandingBookMapper.selectCountByYear();
    }
    /**
     * 根据乡镇统计隐患数量
     * @return
     */
    @Override
    public List<Map<String,Object>> selectHiddenRanking() {
        return tHiddenDangerStandingBookMapper.selectHiddenRanking();
    }
    /**
     * 根据隐患来源统计隐患数量
     * @return
     */
    @Override
    public List<Map<String,Object>> selectHiddenSource() {
        return tHiddenDangerStandingBookMapper.selectHiddenSource();
    }

    /**
     * 隐患统计
     * @return
     */
    @Override
    public Map<String,Integer> hiddenBookStatistics(){
        return tHiddenDangerStandingBookMapper.hiddenBookStatistics();
    }

    /**
     * 判断是否为企业
     * @return
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }

}
