package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TGasuserSafetyDeviceInfoMapper;
import com.zehong.system.domain.TGasuserSafetyDeviceInfo;
import com.zehong.system.service.ITGasuserSafetyDeviceInfoService;

import javax.annotation.Resource;

/**
 * 用户管理-燃气用户-安全装置加装维护Service业务层处理
 * 
 * @author zehong
 * @date 2024-08-27
 */
@Service
public class TGasuserSafetyDeviceInfoServiceImpl implements ITGasuserSafetyDeviceInfoService 
{
    @Resource
    private TGasuserSafetyDeviceInfoMapper tGasuserSafetyDeviceInfoMapper;

    /**
     * 查询用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 用户管理-燃气用户-安全装置加装维护
     */
    @Override
    public TGasuserSafetyDeviceInfo selectTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId)
    {
        return tGasuserSafetyDeviceInfoMapper.selectTGasuserSafetyDeviceInfoById(gasUserSafetyDeviceId);
    }

    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 用户管理-燃气用户-安全装置加装维护
     */
    @Override
    public List<TGasuserSafetyDeviceInfo> selectTGasuserSafetyDeviceInfoList(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        return tGasuserSafetyDeviceInfoMapper.selectTGasuserSafetyDeviceInfoList(tGasuserSafetyDeviceInfo);
    }

    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表-燃气用户界面使用
     *
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 用户管理-燃气用户-安全装置加装维护集合
     */
    @Override
    public List<TGasuserSafetyDeviceInfo> queryNoSelectSafeDeviceInfoList(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo) {
        return tGasuserSafetyDeviceInfoMapper.queryNoSelectSafeDeviceInfoList(tGasuserSafetyDeviceInfo);
    }

    /**
     * 新增用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    @Override
    public int insertTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        return tGasuserSafetyDeviceInfoMapper.insertTGasuserSafetyDeviceInfo(tGasuserSafetyDeviceInfo);
    }

    /**
     * 修改用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    @Override
    public int updateTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo)
    {
        return tGasuserSafetyDeviceInfoMapper.updateTGasuserSafetyDeviceInfo(tGasuserSafetyDeviceInfo);
    }

    /**
     * 批量删除用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceIds 需要删除的用户管理-燃气用户-安全装置加装维护ID
     * @return 结果
     */
    @Override
    public int deleteTGasuserSafetyDeviceInfoByIds(Long[] gasUserSafetyDeviceIds)
    {
        return tGasuserSafetyDeviceInfoMapper.deleteTGasuserSafetyDeviceInfoByIds(gasUserSafetyDeviceIds);
    }

    /**
     * 关联安装加装装置 批量删除
     * @param deviceIds ids
     */
    @Override
    public void deleteSafetyDeviceListInfo(Long[] deviceIds) {
        tGasuserSafetyDeviceInfoMapper.deleteSafetyDeviceListInfo(deviceIds);
    }

    /**
     * 关联安装加装装置 单条删除
     * @param deviceId deviceId
     */
    @Override
    public void deleteSafetyDeviceInfo(Long deviceId) {
        tGasuserSafetyDeviceInfoMapper.deleteSafetyDeviceInfo(deviceId);
    }

    /**
     * 根据燃气用户id查询数据
     * @param userId u
     * @return r
     */
    @Override
    public List<TGasuserSafetyDeviceInfo> selectSafetyDeviceDetailInfoList(Long userId) {
        return tGasuserSafetyDeviceInfoMapper.selectSafetyDeviceDetailInfoList(userId);
    }

    /**
     * 删除用户管理-燃气用户-安全装置加装维护信息
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 结果
     */
    @Override
    public int deleteTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId)
    {
        return tGasuserSafetyDeviceInfoMapper.deleteTGasuserSafetyDeviceInfoById(gasUserSafetyDeviceId);
    }
}
