package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEventHandleMapper;
import com.zehong.system.domain.TEventHandle;
import com.zehong.system.service.ITEventHandleService;

/**
 * 事件处置Service业务层处理
 * 
 * @author zehong
 * @date 2022-03-19
 */
@Service
public class TEventHandleServiceImpl implements ITEventHandleService 
{
    @Autowired
    private TEventHandleMapper tEventHandleMapper;

    /**
     * 查询事件处置
     * 
     * @param handleId 事件处置ID
     * @return 事件处置
     */
    @Override
    public TEventHandle selectTEventHandleById(Long handleId)
    {
        return tEventHandleMapper.selectTEventHandleById(handleId);
    }

    /**
     * 查询事件处置列表
     * 
     * @param tEventHandle 事件处置
     * @return 事件处置
     */
    @Override
    public List<TEventHandle> selectTEventHandleList(TEventHandle tEventHandle)
    {
        return tEventHandleMapper.selectTEventHandleList(tEventHandle);
    }

    /**
     * 新增事件处置
     * 
     * @param tEventHandle 事件处置
     * @return 结果
     */
    @Override
    public int insertTEventHandle(TEventHandle tEventHandle)
    {
        tEventHandle.setCreateTime(DateUtils.getNowDate());
        return tEventHandleMapper.insertTEventHandle(tEventHandle);
    }

    /**
     * 修改事件处置
     * 
     * @param tEventHandle 事件处置
     * @return 结果
     */
    @Override
    public int updateTEventHandle(TEventHandle tEventHandle)
    {
        tEventHandle.setGuidanceTime(new Date());
        return tEventHandleMapper.updateTEventHandle(tEventHandle);
    }

    /**
     * 批量删除事件处置
     * 
     * @param handleIds 需要删除的事件处置ID
     * @return 结果
     */
    @Override
    public int deleteTEventHandleByIds(Long[] handleIds)
    {
        return tEventHandleMapper.deleteTEventHandleByIds(handleIds);
    }

    /**
     * 删除事件处置信息
     * 
     * @param handleId 事件处置ID
     * @return 结果
     */
    @Override
    public int deleteTEventHandleById(Long handleId)
    {
        return tEventHandleMapper.deleteTEventHandleById(handleId);
    }
}
