package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmployedPeopleInfoErrorMapper;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import com.zehong.system.service.ITEmployedPeopleInfoErrorService;

/**
 * 从业人员错误导入记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-01
 */
@Service
public class TEmployedPeopleInfoErrorServiceImpl implements ITEmployedPeopleInfoErrorService 
{
    @Autowired
    private TEmployedPeopleInfoErrorMapper tEmployedPeopleInfoErrorMapper;

    /**
     * 查询从业人员错误导入记录
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 从业人员错误导入记录
     */
    @Override
    public TEmployedPeopleInfoError selectTEmployedPeopleInfoErrorById(Long employedPeopleErrorId)
    {
        return tEmployedPeopleInfoErrorMapper.selectTEmployedPeopleInfoErrorById(employedPeopleErrorId);
    }

    /**
     * 查询从业人员错误导入记录列表
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 从业人员错误导入记录
     */
    @Override
    public List<TEmployedPeopleInfoError> selectTEmployedPeopleInfoErrorList(TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        return tEmployedPeopleInfoErrorMapper.selectTEmployedPeopleInfoErrorList(tEmployedPeopleInfoError);
    }

    /**
     * 新增从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    @Override
    public int insertTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        return tEmployedPeopleInfoErrorMapper.insertTEmployedPeopleInfoError(tEmployedPeopleInfoError);
    }

    /**
     * 批量插入 错误数据
     * @param employedPeopleInfoErrors e
     * @return r
     */
    @Override
    public int batchInsertTEmployedPeopleInfoError(List<TEmployedPeopleInfoError> employedPeopleInfoErrors) {

        if (employedPeopleInfoErrors == null || employedPeopleInfoErrors.size() == 0) {
            return 0;
        }
        return tEmployedPeopleInfoErrorMapper.batchInsertTEmployedPeopleInfoError(employedPeopleInfoErrors);
    }

    /**
     * 修改从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    @Override
    public int updateTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError)
    {
        return tEmployedPeopleInfoErrorMapper.updateTEmployedPeopleInfoError(tEmployedPeopleInfoError);
    }

    /**
     * 批量删除从业人员错误导入记录
     * 
     * @param employedPeopleErrorIds 需要删除的从业人员错误导入记录ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoErrorByIds(Long[] employedPeopleErrorIds)
    {
        return tEmployedPeopleInfoErrorMapper.deleteTEmployedPeopleInfoErrorByIds(employedPeopleErrorIds);
    }

    /**
     * 删除从业人员错误导入记录信息
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoErrorById(Long employedPeopleErrorId)
    {
        return tEmployedPeopleInfoErrorMapper.deleteTEmployedPeopleInfoErrorById(employedPeopleErrorId);
    }

    @Override
    public int clearImportError() {
        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();
        return tEmployedPeopleInfoErrorMapper.countByCreateByInt(userId + "");
    }
}
