package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyDeviceMapper;
import com.zehong.system.domain.TEmergencyDevice;
import com.zehong.system.service.ITEmergencyDeviceService;

/**
 * 应急设备Service业务层处理
 * 
 * @author zehong
 * @date 2022-03-17
 */
@Service
public class TEmergencyDeviceServiceImpl implements ITEmergencyDeviceService 
{
    @Autowired
    private TEmergencyDeviceMapper tEmergencyDeviceMapper;

    /**
     * 查询应急设备
     * 
     * @param id 应急设备ID
     * @return 应急设备
     */
    @Override
    public TEmergencyDevice selectTEmergencyDeviceById(String id)
    {
        return tEmergencyDeviceMapper.selectTEmergencyDeviceById(id);
    }

    /**
     * 查询应急设备列表
     * 
     * @param tEmergencyDevice 应急设备
     * @return 应急设备
     */
    @Override
    public List<TEmergencyDevice> selectTEmergencyDeviceList(TEmergencyDevice tEmergencyDevice)
    {
        return tEmergencyDeviceMapper.selectTEmergencyDeviceList(tEmergencyDevice);
    }

    /**
     * 新增应急设备
     * 
     * @param tEmergencyDevice 应急设备
     * @return 结果
     */
    @Override
    public int insertTEmergencyDevice(TEmergencyDevice tEmergencyDevice)
    {
        tEmergencyDevice.setCreateTime(DateUtils.getNowDate());
        return tEmergencyDeviceMapper.insertTEmergencyDevice(tEmergencyDevice);
    }

    /**
     * 修改应急设备
     * 
     * @param tEmergencyDevice 应急设备
     * @return 结果
     */
    @Override
    public int updateTEmergencyDevice(TEmergencyDevice tEmergencyDevice)
    {
        tEmergencyDevice.setUpdateTime(DateUtils.getNowDate());
        return tEmergencyDeviceMapper.updateTEmergencyDevice(tEmergencyDevice);
    }

    /**
     * 批量删除应急设备
     * 
     * @param ids 需要删除的应急设备ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDeviceByIds(String[] ids)
    {
        return tEmergencyDeviceMapper.deleteTEmergencyDeviceByIds(ids);
    }

    /**
     * 删除应急设备信息
     * 
     * @param id 应急设备ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDeviceById(String id)
    {
        return tEmergencyDeviceMapper.deleteTEmergencyDeviceById(id);
    }
}
