package com.zehong.system.service.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.ServletUtils;
import com.zehong.system.domain.*;
import com.zehong.system.service.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceInfoMapper;

import javax.annotation.Resource;

/**
 * 设备信息Service业务层处理
 *
 * @author zehong
 * @date 2022-01-27
 */
@Service
public class TDeviceInfoServiceImpl implements ITDeviceInfoService
{
    @Resource
    private TDeviceInfoMapper tDeviceInfoMapper;

    @Resource
    IPipeInterfaceService iPipeInterfaceService;

    @Resource
    private ITDetectorUserService tDetectorUserService;


    @Resource
    private ITDeviceUserService tDeviceUserService;

    @Resource
    private ITVideoManagerService itVideoManagerService;

    @Resource
    private ITYehuaqiUserService yehuaqiUserService;

    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    @Override
    public TDeviceInfo selectTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
    }

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);
    }

    /**
     *
     * 大屏端 全局搜素 设备，场站，用户信息，监控  步骤一
     * */
    @Override
    public Map<Object, List<Map<String, Object>>> queryBasicInforByNameForBigWindows(String name) {
        Map<Object, List<Map<String, Object>>> stringListHashMap = new HashMap<>();
        List<Map<String, Object>> maps = tDeviceInfoMapper.queryBasicInforByNameForBigWindows(name);
        if (maps.size() > 0) {
            stringListHashMap = maps.stream().collect(Collectors.groupingBy((item -> item.get("type"))));
        }

        return stringListHashMap;
    }

    /**
     *
     * 大屏端 全局搜素 设备，场站，用户信息，监控  步骤二
     * */
    @Override
    public Object queryBasicInforByTypeAndIdForBigWindows(String type, String id) {

        // 1 是阀门井  2 是调压箱 都是查询 device 表
        if(("1".equals(type) || "2".equals(type)) && id != null) {
            return initPressureFlow(id);
        }

        // 3  是场站
        if(("3".equals(type)) && id != null) {
            return initTSiteStationInfoData(id);
        }
        // 4 5 6 是居民用户，商业用户，工业用户
        if(("4".equals(type) || "5".equals(type) || "6".equals(type)) && id != null) {
            TDetectorUser tDetectorUser = new TDetectorUser();
            tDetectorUser.setUserId(Long.parseLong(id));
            return tDetectorUserService.detectorUserList(tDetectorUser);
        }

        //7 是监控
        if ("7".equals(type)) {
            return itVideoManagerService.selectTVideoManagerById(Long.parseLong(id));
        }

        //8 是餐饮单位液化气用户
        if("8".equals(type) && id != null) {
            TYehuaqiUser tYehuaqiUser = new TYehuaqiUser();
            tYehuaqiUser.setUserId(Long.parseLong(id));

            List<TYehuaqiUser> tYehuaqiUsers = yehuaqiUserService.selectAllUserList(tYehuaqiUser);
            if (tYehuaqiUsers.size() > 0) {
                return tYehuaqiUsers.get(0);
            }
        }

        //9 是管道
        if("9".equals(type) && id != null) {
            return iPipeInterfaceService.getPipeBypipeId(id);
        }

        return null;
    }

    /**
     * 封装场站信息
     * @param deviceId 设备id
     * @return object
     */
    private Object initTSiteStationInfoData(String deviceId) {
        TSiteStationInfoDataList tSiteStationInfoDataList = new TSiteStationInfoDataList();
        List<TSiteStationInfoData> TSiteStationInfoDataList=new ArrayList<>();
        //查询场站下级设备数据
        List<PressureFlow> pressureFlows = iPipeInterfaceService.selecttSiteStationInfoDataList(deviceId);
        //临时存储压力表数据数组
        List<PressureFlow> pressureList=new ArrayList<>();
        //临时存储流量计数据数组
        List<PressureFlow> flowmeterList=new ArrayList<>();
        //临时存储探测器数据数组
        List<PressureFlow> detectorList=new ArrayList();
        /**循环下级全部数据*/
        for (int s=0;s<pressureFlows.size();s++){
            //判断是压力表还是流量计   1压力表  2流量计 3探测器
            if (pressureFlows.get(s).getDeviceType().equals("1")){
                pressureList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("2")){
                flowmeterList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("3")){
                detectorList.add(pressureFlows.get(s));
            }
        }
        //创建下级数据list数组
        List<SubordinateEquipmentList> subordinateEquipmentLists=new ArrayList<>();
        /**循环三次  每次代表 1压力表  2流量计  3探测器*/
        for (int t=0;t<3;t++){
            SubordinateEquipmentList subordinateEquipmentList=new SubordinateEquipmentList();
            if (t==0){  /**添加压力表数据*/
                if (pressureList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(pressureList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(pressureList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(pressureList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(pressureList.size());
                }
                subordinateEquipmentList.setDataType(1);
            }else if (t==1){  /**添加流量计数据*/
                if (flowmeterList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(flowmeterList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(flowmeterList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(flowmeterList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(flowmeterList.size());
                }
                subordinateEquipmentList.setDataType(2);
            }else if (t==2){  /**添加探测器数据*/
                if (detectorList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(detectorList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(detectorList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(detectorList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(detectorList.size());
                }
                subordinateEquipmentList.setDataType(3);
            }
            subordinateEquipmentLists.add(subordinateEquipmentList);
        }
        TSiteStationInfoData deviceData=new TSiteStationInfoData();
        deviceData.setSubordinateEquipmentList(subordinateEquipmentLists);
        TSiteStationInfoDataList.add(deviceData);
        tSiteStationInfoDataList.setData(TSiteStationInfoDataList);
        return tSiteStationInfoDataList;
    }


    /**
     * 封装 阀门井和调压箱数据
     * @param deviceId 设备id
     * @return object
     */
    private Object initPressureFlow (String deviceId) {

        //最后返回的封装类型
        DeviceList deviceList=new DeviceList();
        List<DeviceData> DeviceList=new ArrayList<>();
        //查询关联设备下级数据方法
        List<PressureFlow> pressureFlows = iPipeInterfaceService.selectPressureFlow(deviceId);
        //临时存储压力表数据数组
        List<PressureFlow> pressureList=new ArrayList<>();
        //临时存储流量计数据数组
        List<PressureFlow> flowmeterList=new ArrayList<>();
        //临时存储探测器数据数组
        List<PressureFlow> detectorList=new ArrayList();
        /**循环下级全部数据*/
        for (int s=0;s<pressureFlows.size();s++){
            //判断是压力表还是流量计   1压力表  2流量计 3探测器
            if (pressureFlows.get(s).getDeviceType().equals("1")){
                pressureList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("2")){
                flowmeterList.add(pressureFlows.get(s));
            }else if (pressureFlows.get(s).getDeviceType().equals("3")){
                detectorList.add(pressureFlows.get(s));
            }
        }
        //创建下级数据list数组
        List<SubordinateEquipmentList> subordinateEquipmentLists=new ArrayList<>();
        /**循环三次  每次代表 1压力表  2流量计  3探测器*/
        for (int t=0;t<3;t++){
            SubordinateEquipmentList subordinateEquipmentList=new SubordinateEquipmentList();
            if (t==0){  /**添加压力表数据*/
                if (pressureList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(pressureList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(pressureList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(pressureList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(pressureList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(pressureList.size());
                }
                subordinateEquipmentList.setDataType(1);
            }else if (t==1){  /**添加流量计数据*/
                if (flowmeterList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(flowmeterList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(flowmeterList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(flowmeterList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(flowmeterList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(flowmeterList.size());
                }
                subordinateEquipmentList.setDataType(2);
            }else if (t==2){  /**添加探测器数据*/
                if (detectorList.size()!=0){
                    /**查询下级在线设备数量*/
                    int onLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 0);
                    subordinateEquipmentList.setOnlineEquipment(onLine);
                    /**查询下级离线设备数量*/
                    int offLine = iPipeInterfaceService.selectOnlineQuantity(detectorList, 1);
                    subordinateEquipmentList.setOfflineEquipment(offLine);
                    /**查询历史报警数量*/
                    int historicalAlarm = iPipeInterfaceService.selectHistoricalAlarm(detectorList);
                    subordinateEquipmentList.setHistoricalAlarm(historicalAlarm);
                    /**查询已处理报警*/
                    int processAlarm = iPipeInterfaceService.selectProcessAlarm(detectorList);
                    subordinateEquipmentList.setAlarmProcessed(processAlarm);
                    /**查询报警中*/
                    int inAlarm = iPipeInterfaceService.selectInAlarm(detectorList);
                    subordinateEquipmentList.setInAlarm(inAlarm);
                    subordinateEquipmentList.setNumberPressureGauges(detectorList.size());
                }
                subordinateEquipmentList.setDataType(3);
            }
            subordinateEquipmentLists.add(subordinateEquipmentList);
        }
        DeviceData deviceData=new DeviceData();
        deviceData.setSubordinateEquipmentList(subordinateEquipmentLists);
        DeviceList.add(deviceData);
        deviceList.setData(DeviceList);

        return deviceList;
    }

    @Override
    public List<TDeviceInfo> selectDeviceList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.selectDeviceList(tDeviceInfo);
    }


    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setCreateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.insertTDeviceInfo(tDeviceInfo);
    }

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setUpdateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.updateTDeviceInfo(tDeviceInfo);
    }

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoByIds(Long[] deviceIds)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoByIds(deviceIds);
    }

    /**
     * 删除设备信息信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoById(deviceId);
    }

    /**
     * 添加关联设备信息表数据
     * @param gettDeviceInfoS
     */
    @Override
    public void insertDeviceDetailInfo(TDeviceInfoS gettDeviceInfoS) {
        tDeviceInfoMapper.insertDeviceDetailInfo(gettDeviceInfoS);
    }

    /**
     * 获取设备详细信息列表
     * @param deviceId
     * @return
     */
    @Override
    public List<TDeviceInfoS> getdeviceDetailInfo(Long deviceId) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.getdeviceDetailInfo(deviceId);
        return tDeviceInfoS;
    }

    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    @Override
    public List<TDeviceInfoS> selectDetailInfo(TDeviceInfoS tDeviceInfos) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.selectDetailInfo(tDeviceInfos);
        return tDeviceInfoS;
    }

    /**
     * 关联设备数据删除接口
     * @param deviceIds
     */
    @Override
    public void deleteDetailInfo(Long[] deviceIds) {
        tDeviceInfoMapper.deleteDetailInfo(deviceIds);
    }

    /**
     * 关联设备数据删除接口 单条删除
     * @param deviceId
     */
    @Override
    public void deleteDetailinfOS(int deviceId) {
        tDeviceInfoMapper.deleteDetailinfOS(deviceId);
    }

    /**
     * 将关联设备信息与设备进行绑定
     * @param gettDeviceInfoS
     */
    @Override
    public void updatetRelationDeviceDetailInfo(@Param("gettDeviceInfoS")List<TDeviceInfoS> gettDeviceInfoS,@Param("id") Long id,@Param("relationDevicetype") String relationDevicetype) {
        tDeviceInfoMapper.updatetRelationDeviceDetailInfo(gettDeviceInfoS,id,relationDevicetype);
    }

    /**
     * 查询设备已经关联的关联设备
     * @param id
     * @return
     */
    @Override
    public List<TDeviceInfoS> selectDetailInfoList(@Param("id") int id,@Param("relationDeviceType")String relationDeviceType) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.selectDetailInfoList(id,relationDeviceType);
        return tDeviceInfoS;
    }

    /**
     * 解绑 设备与关联设备关系
     * @param deviceId
     */
    @Override
    public void deleteDeviceDetailInfo(int deviceId) {
        tDeviceInfoMapper.deleteDeviceDetailInfo(deviceId);
    }
    /**
     * 查询设备数量
     * @return
     */
    @Override
    public Map<String,Object> selectDeviceNum(String enterpriseId){
        return tDeviceInfoMapper.selectDeviceNum(enterpriseId.split(","));
    }
}
