package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDetectorUserErrorMapper;
import com.zehong.system.domain.TDetectorUserError;
import com.zehong.system.service.ITDetectorUserErrorService;

/**
 * 燃气用户错误导入记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-08-30
 */
@Service
public class TDetectorUserErrorServiceImpl implements ITDetectorUserErrorService 
{
    @Autowired
    private TDetectorUserErrorMapper tDetectorUserErrorMapper;

    /**
     * 查询燃气用户错误导入记录
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 燃气用户错误导入记录
     */
    @Override
    public TDetectorUserError selectTDetectorUserErrorById(Long userId)
    {
        return tDetectorUserErrorMapper.selectTDetectorUserErrorById(userId);
    }

    /**
     * 查询燃气用户错误导入记录列表
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 燃气用户错误导入记录
     */
    @Override
    public List<TDetectorUserError> selectTDetectorUserErrorList(TDetectorUserError tDetectorUserError)
    {
        return tDetectorUserErrorMapper.selectTDetectorUserErrorList(tDetectorUserError);
    }

    /**
     * 新增燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    @Override
    public int insertTDetectorUserError(TDetectorUserError tDetectorUserError)
    {
        return tDetectorUserErrorMapper.insertTDetectorUserError(tDetectorUserError);
    }

    /**
     * 修改燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    @Override
    public int updateTDetectorUserError(TDetectorUserError tDetectorUserError)
    {
        return tDetectorUserErrorMapper.updateTDetectorUserError(tDetectorUserError);
    }

    /**
     * 批量删除燃气用户错误导入记录
     * 
     * @param userIds 需要删除的燃气用户错误导入记录ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorUserErrorByIds(Long[] userIds)
    {
        return tDetectorUserErrorMapper.deleteTDetectorUserErrorByIds(userIds);
    }

    /**
     * 删除燃气用户错误导入记录信息
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorUserErrorById(Long userId)
    {
        return tDetectorUserErrorMapper.deleteTDetectorUserErrorById(userId);
    }

    /**
     * 根据企业id统计错误数据
     * @return r
     */
    @Override
    public int countByBeyondEnterpriseId() {

        LoginUser loginUser = SecurityUtils.getLoginUser();
        String deptId = loginUser.getUser().getDeptId();

        return tDetectorUserErrorMapper.countByBeyondEnterpriseId(deptId);
    }

    /**
     * 根据企业id 清除数据
     * @return r
     */
    @Override
    public int clearImportErrorByEnterpriseId() {

        LoginUser loginUser = SecurityUtils.getLoginUser();
        String deptId = loginUser.getUser().getDeptId();

        return tDetectorUserErrorMapper.clearByBeyondEnterpriseId(deptId);
    }
}
