package com.zehong.system.service.impl;

import com.github.pagehelper.PageInfo;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDetectorInfo;
import com.zehong.system.domain.TDetectorReportData;
import com.zehong.system.domain.form.TDetectorReportDataQueryForm;
import com.zehong.system.domain.vo.TDetectorAlarmInfoVO;
import com.zehong.system.mapper.TDetectorReportDataMapper;
import com.zehong.system.service.ITDetectorReportDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 设备上报的数据Service业务层处理
 * 
 * @author zehong
 * @date 2021-11-08
 */
@Service
public class TDetectorReportDataServiceImpl implements ITDetectorReportDataService
{
    @Autowired
    private TDetectorReportDataMapper tDetectorReportDataMapper;

    /**
     * 查询设备上报的数据
     * 
     * @param id 设备上报的数据ID
     * @return 设备上报的数据
     */
    @Override
    public TDetectorReportData selectTDetectorReportDataById(Long id)
    {
        return tDetectorReportDataMapper.selectTDetectorReportDataById(id);
    }

    @Override
    public List<TDetectorReportData> selectTDetectorReportDataByCode(String detectorCode)
    {
        return tDetectorReportDataMapper.selectTDetectorReportDataByCode(detectorCode);
    }

    @Override
    public List<TDetectorAlarmInfoVO> selectTDetectorAlarm()
    {
        return tDetectorReportDataMapper.selectTDetectorAlarm();
    }
    @Override
    public TDetectorAlarmInfoVO selectAlarm(Integer id)
    {
        return tDetectorReportDataMapper.selectAlarm(id);
    }

    @Override
    public List<TDetectorReportData> selectRealtimeDataList()
    {
        return tDetectorReportDataMapper.selectRealtimeDataList();
    }

    @Override
    public List<TDetectorReportData> countDetectorByUserId(TDetectorInfo tDetectorInfo){
        return tDetectorReportDataMapper.countDetectorByUserId(tDetectorInfo);
    }

    /**
     * 查询设备上报的数据列表
     * 
     * @param tDetectorReportDataQueryForm 设备上报的数据
     * @return 设备上报的数据
     */
    @Override
    public List<TDetectorReportData> selectTDetectorReportDataList(TDetectorReportDataQueryForm tDetectorReportDataQueryForm)
    {
        return tDetectorReportDataMapper.selectTDetectorReportDataList(tDetectorReportDataQueryForm);
    }

    /**
     * 查询设备上报的数据分页列表
     *
     * @param tDetectorReportDataQueryForm 设备上报的数据
     * @return 设备上报的数据
     */
    @Override
    public PageInfo<TDetectorReportData> selectTDetectorReportDataPage(TDetectorReportDataQueryForm tDetectorReportDataQueryForm)
    {
        return new PageInfo(tDetectorReportDataMapper.selectTDetectorReportDataList(tDetectorReportDataQueryForm));
    }

    /**
     * 新增设备上报的数据
     * 
     * @param tDetectorReportData 设备上报的数据
     * @return 结果
     */
    @Override
    public int insertTDetectorReportData(TDetectorReportData tDetectorReportData)
    {
        tDetectorReportData.setCreateTime(DateUtils.getNowDate());
        return tDetectorReportDataMapper.insertTDetectorReportData(tDetectorReportData);
    }

    /**
     * 修改设备上报的数据
     * 
     * @param tDetectorReportData 设备上报的数据
     * @return 结果
     */
    @Override
    public int updateTDetectorReportData(TDetectorReportData tDetectorReportData)
    {
        return tDetectorReportDataMapper.updateTDetectorReportData(tDetectorReportData);
    }

    /**
     * 批量删除设备上报的数据
     * 
     * @param ids 需要删除的设备上报的数据ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorReportDataByIds(Long[] ids)
    {
        return tDetectorReportDataMapper.deleteTDetectorReportDataByIds(ids);
    }

    /**
     * 删除设备上报的数据信息
     * 
     * @param id 设备上报的数据ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorReportDataById(Long id)
    {
        return tDetectorReportDataMapper.deleteTDetectorReportDataById(id);
    }
}
