package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeliveryRecord;
import com.zehong.system.mapper.TDeliveryRecordMapper;
import com.zehong.system.service.ITDeliveryRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 配送记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-08-22
 */
@Service
public class TDeliveryRecordServiceImpl implements ITDeliveryRecordService 
{
    @Autowired
    private TDeliveryRecordMapper tDeliveryRecordMapper;

    /**
     * 查询配送记录
     * 
     * @param deliveryRecordId 配送记录ID
     * @return 配送记录
     */
    @Override
    public TDeliveryRecord selectTDeliveryRecordById(Long deliveryRecordId)
    {
        return tDeliveryRecordMapper.selectTDeliveryRecordById(deliveryRecordId);
    }

    /**
     * 查询配送记录列表
     * 
     * @param tDeliveryRecord 配送记录
     * @return 配送记录
     */
    @Override
    public List<TDeliveryRecord> selectTDeliveryRecordList(TDeliveryRecord tDeliveryRecord)
    {
        return tDeliveryRecordMapper.selectTDeliveryRecordList(tDeliveryRecord);
    }

    /**
     * 新增配送记录
     * 
     * @param tDeliveryRecord 配送记录
     * @return 结果
     */
    @Override
    public int insertTDeliveryRecord(TDeliveryRecord tDeliveryRecord)
    {
        tDeliveryRecord.setCreateTime(DateUtils.getNowDate());
        return tDeliveryRecordMapper.insertTDeliveryRecord(tDeliveryRecord);
    }

    /**
     * 修改配送记录
     * 
     * @param tDeliveryRecord 配送记录
     * @return 结果
     */
    @Override
    public int updateTDeliveryRecord(TDeliveryRecord tDeliveryRecord)
    {
        tDeliveryRecord.setUpdateTime(DateUtils.getNowDate());
        return tDeliveryRecordMapper.updateTDeliveryRecord(tDeliveryRecord);
    }

    /**
     * 批量删除配送记录
     * 
     * @param deliveryRecordIds 需要删除的配送记录ID
     * @return 结果
     */
    @Override
    public int deleteTDeliveryRecordByIds(Long[] deliveryRecordIds)
    {
        return tDeliveryRecordMapper.deleteTDeliveryRecordByIds(deliveryRecordIds);
    }

    /**
     * 删除配送记录信息
     * 
     * @param deliveryRecordId 配送记录ID
     * @return 结果
     */
    @Override
    public int deleteTDeliveryRecordById(Long deliveryRecordId)
    {
        return tDeliveryRecordMapper.deleteTDeliveryRecordById(deliveryRecordId);
    }
}
