package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TComplainDealEvaluate;
import com.zehong.system.mapper.TComplainDealEvaluateMapper;
import com.zehong.system.service.ITComplainDealEvaluateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 燃气投诉处置-评价Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-06
 */
@Service
public class TComplainDealEvaluateServiceImpl implements ITComplainDealEvaluateService
{
    @Autowired
    private TComplainDealEvaluateMapper tComplainDealEvaluateMapper;

    /**
     * 查询燃气投诉处置-评价
     * 
     * @param complainDealEvaluateId 燃气投诉处置-评价ID
     * @return 燃气投诉处置-评价
     */
    @Override
    public TComplainDealEvaluate selectTComplainDealEvaluateById(Long complainDealEvaluateId)
    {
        return tComplainDealEvaluateMapper.selectTComplainDealEvaluateById(complainDealEvaluateId);
    }

    /**
     * 查询燃气投诉处置-评价
     * @param complainDealId 燃气投诉处置
     * @return
     */
    @Override
    public TComplainDealEvaluate selectTComplainDealEvaluateByComplainDealId(Long complainDealId) {
        return tComplainDealEvaluateMapper.selectTComplainDealEvaluateByComplainDealId(complainDealId);
    }

    /**
     * 查询燃气投诉处置-评价列表
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 燃气投诉处置-评价
     */
    @Override
    public List<TComplainDealEvaluate> selectTComplainDealEvaluateList(TComplainDealEvaluate tComplainDealEvaluate)
    {
        return tComplainDealEvaluateMapper.selectTComplainDealEvaluateList(tComplainDealEvaluate);
    }

    /**
     * 新增燃气投诉处置-评价
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 结果
     */
    @Override
    public int insertTComplainDealEvaluate(TComplainDealEvaluate tComplainDealEvaluate)
    {
        tComplainDealEvaluate.setCreateTime(DateUtils.getNowDate());
        return tComplainDealEvaluateMapper.insertTComplainDealEvaluate(tComplainDealEvaluate);
    }

    /**
     * 修改燃气投诉处置-评价
     * 
     * @param tComplainDealEvaluate 燃气投诉处置-评价
     * @return 结果
     */
    @Override
    public int updateTComplainDealEvaluate(TComplainDealEvaluate tComplainDealEvaluate)
    {
        return tComplainDealEvaluateMapper.updateTComplainDealEvaluate(tComplainDealEvaluate);
    }

    /**
     * 批量删除燃气投诉处置-评价
     * 
     * @param complainDealEvaluateIds 需要删除的燃气投诉处置-评价ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealEvaluateByIds(Long[] complainDealEvaluateIds)
    {
        return tComplainDealEvaluateMapper.deleteTComplainDealEvaluateByIds(complainDealEvaluateIds);
    }

    /**
     * 删除燃气投诉处置-评价信息
     * 
     * @param complainDealEvaluateId 燃气投诉处置-评价ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealEvaluateById(Long complainDealEvaluateId)
    {
        return tComplainDealEvaluateMapper.deleteTComplainDealEvaluateById(complainDealEvaluateId);
    }
}
