package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.SysSettingMapper;
import com.zehong.system.domain.SysSetting;
import com.zehong.system.service.ISysSettingService;

/**
 * 系统参数配置Service业务层处理
 * 
 * @author zehong
 * @date 2021-11-23
 */
@Service
public class SysSettingServiceImpl implements ISysSettingService 
{
    @Autowired
    private SysSettingMapper sysSettingMapper;

    /**
     * 查询系统参数配置
     * 
     * @param systemId 系统参数配置ID
     * @return 系统参数配置
     */
    @Override
    public SysSetting selectSysSettingById(Integer systemId)
    {
        return sysSettingMapper.selectSysSettingById(systemId);
    }

    @Override
    public SysSetting selectSysSettingBySystemKey(String systemKey) {
        return sysSettingMapper.getSystemValueByKey(systemKey);
    }

    /**
     * 查询系统参数配置列表
     * 
     * @param sysSetting 系统参数配置
     * @return 系统参数配置
     */
    @Override
    public List<SysSetting> selectSysSettingList(SysSetting sysSetting)
    {
        return sysSettingMapper.selectSysSettingList(sysSetting);
    }

    /**
     * 新增系统参数配置
     * 
     * @param sysSetting 系统参数配置
     * @return 结果
     */
    @Override
    public int insertSysSetting(SysSetting sysSetting)
    {
        sysSetting.setCreateTime(DateUtils.getNowDate());
        return sysSettingMapper.insertSysSetting(sysSetting);
    }

    /**
     * 修改系统参数配置
     * 
     * @param sysSetting 系统参数配置
     * @return 结果
     */
    @Override
    public int updateSysSetting(SysSetting sysSetting)
    {
        sysSetting.setUpdateTime(DateUtils.getNowDate());
        return sysSettingMapper.updateSysSetting(sysSetting);
    }

    /**
     * 批量删除系统参数配置
     * 
     * @param systemIds 需要删除的系统参数配置ID
     * @return 结果
     */
    @Override
    public int deleteSysSettingByIds(Integer[] systemIds)
    {
        return sysSettingMapper.deleteSysSettingByIds(systemIds);
    }

    /**
     * 删除系统参数配置信息
     * 
     * @param systemId 系统参数配置ID
     * @return 结果
     */
    @Override
    public int deleteSysSettingById(Integer systemId)
    {
        return sysSettingMapper.deleteSysSettingById(systemId);
    }

    /**
     * 根据systemKey获取value
     */
    @Override
    public SysSetting getSystemValueByKey(String systemKey) {
        return sysSettingMapper.getSystemValueByKey(systemKey);
    }
}
