package com.zehong.system.service.impl;

import com.zehong.system.domain.TrainStat;
import com.zehong.system.domain.TrainStatDetail;
import com.zehong.system.mapper.TTrainStatMapper;
import com.zehong.system.service.ITTrainStatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ITTrainStatServiceImpl implements ITTrainStatService{

    @Autowired
    private TTrainStatMapper tTrainStatMapper;
    /**
     * 培训统计查询
     * @param trainStat 查询条件
     * @return
     */
    @Override
    public List<TrainStat> trainStatData(TrainStat trainStat) {
        return tTrainStatMapper.trainStatData(trainStat);
    }

    /**
     * 培训统计详情
     * @param trainManageId 培训id
     * @return
     */
    @Override
    public List<TrainStatDetail> trainStatDetail(Long trainManageId) {
        return tTrainStatMapper.trainStatDetail(trainManageId);
    }
}
