package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;

/**
 * 液化石油气监管-液化气用户-安全装置加装维护Service接口
 * 
 * @author zehong
 * @date 2024-09-09
 */
public interface ITYehuaqiuserSafetyDeviceInfoService 
{
    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 液化石油气监管-液化气用户-安全装置加装维护
     */
    public TYehuaqiuserSafetyDeviceInfo selectTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId);

    /**
     * 根据要用户id 查询列表
     * @param userId user
     * @return l
     */
    public List<TYehuaqiuserSafetyDeviceInfo> queryDeviceInfoByUserId(Long userId);

    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护列表
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 液化石油气监管-液化气用户-安全装置加装维护集合
     */
    public List<TYehuaqiuserSafetyDeviceInfo> selectTYehuaqiuserSafetyDeviceInfoList(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 新增液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    public int insertTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 修改液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    public int updateTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 批量删除液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceIds 需要删除的液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTYehuaqiuserSafetyDeviceInfoByIds(Long[] fSafetyDeviceIds);

    /**
     * 删除液化石油气监管-液化气用户-安全装置加装维护信息
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId);
}
