package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TWorkTask;
import com.zehong.system.domain.TWorkTaskInspect;

/**
 * 入户安检Service接口
 * 
 * @author zehong
 * @date 2023-09-15
 */
public interface ITWorkTaskInspectService 
{
    /**
     * 查询入户安检
     * 
     * @param inspectId 入户安检ID
     * @return 入户安检
     */
    public TWorkTaskInspect selectTWorkTaskInspectById(Long inspectId);

    /**
     * 查询入户安检列表
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 入户安检集合
     */
    public List<TWorkTaskInspect> selectTWorkTaskInspectList(TWorkTaskInspect tWorkTaskInspect);
    public List<TWorkTaskInspect> selectTWorkTaskInspectwxList(TWorkTaskInspect tWorkTaskInspect);
    public List<TDetectorUser> selectTWorkTaskInspectwxnotList(TWorkTaskInspect tWorkTaskInspect);


    /**
     * 新增入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    public int insertTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 修改入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    public int updateTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 批量删除入户安检
     * 
     * @param inspectIds 需要删除的入户安检ID
     * @return 结果
     */
    public int deleteTWorkTaskInspectByIds(Long[] inspectIds);

    /**
     * 删除入户安检信息
     * 
     * @param inspectId 入户安检ID
     * @return 结果
     */
    public int deleteTWorkTaskInspectById(Long inspectId);

    /**
     * 入户安检统计
     * @param tWorkTaskInspect 入户安检实体
     * @return
     */
    List<Map<String,Object>> inspectStatistic(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 查询任务已安检用户
     * @param taskId 任务主键
     * @return
     */
    List<Long> getHasInspectByTaskId(Long taskId);
}
