package com.zehong.system.service;

import com.zehong.system.domain.TTaskRecord;

import java.util.List;

/**
 * 任务记录Service接口
 * 
 * @author zehong
 * @date 2023-11-06
 */
public interface ITTaskRecordService 
{
    /**
     * 查询任务记录
     * 
     * @param taskRecordId 任务记录ID
     * @return 任务记录
     */
    public TTaskRecord selectTTaskRecordById(Long taskRecordId);

    /**
     * 查询任务记录列表
     * 
     * @param tTaskRecord 任务记录
     * @return 任务记录集合
     */
    public List<TTaskRecord> selectTTaskRecordList(TTaskRecord tTaskRecord);

    /**
     * 新增任务记录
     * 
     * @param tTaskRecord 任务记录
     * @return 结果
     */
    public int insertTTaskRecord(TTaskRecord tTaskRecord);

    /**
     * 修改任务记录
     * 
     * @param tTaskRecord 任务记录
     * @return 结果
     */
    public int updateTTaskRecord(TTaskRecord tTaskRecord);

    /**
     * 批量删除任务记录
     * 
     * @param taskRecordIds 需要删除的任务记录ID
     * @return 结果
     */
    public int deleteTTaskRecordByIds(Long[] taskRecordIds);

    /**
     * 删除任务记录信息
     * 
     * @param taskRecordId 任务记录ID
     * @return 结果
     */
    public int deleteTTaskRecordById(Long taskRecordId);
}
