package com.zehong.system.service;

import com.zehong.system.domain.TSafeCheckRecord;

import java.util.List;

/**
 * 安检记录Service接口
 * 
 * @author zehong
 * @date 2023-08-21
 */
public interface ITSafeCheckRecordService 
{
    /**
     * 查询安检记录
     * 
     * @param safeCheckId 安检记录ID
     * @return 安检记录
     */
    public TSafeCheckRecord selectTSafeCheckRecordById(Long safeCheckId);

    /**
     * 查询安检记录列表
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 安检记录集合
     */
    public List<TSafeCheckRecord> selectTSafeCheckRecordList(TSafeCheckRecord tSafeCheckRecord);

    /**
     * 新增安检记录
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 结果
     */
    public int insertTSafeCheckRecord(TSafeCheckRecord tSafeCheckRecord);

    /**
     * 修改安检记录
     * 
     * @param tSafeCheckRecord 安检记录
     * @return 结果
     */
    public int updateTSafeCheckRecord(TSafeCheckRecord tSafeCheckRecord);

    /**
     * 批量删除安检记录
     * 
     * @param safeCheckIds 需要删除的安检记录ID
     * @return 结果
     */
    public int deleteTSafeCheckRecordByIds(Long[] safeCheckIds);

    /**
     * 删除安检记录信息
     * 
     * @param safeCheckId 安检记录ID
     * @return 结果
     */
    public int deleteTSafeCheckRecordById(Long safeCheckId);
}
