package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TLpgAirChargeFiles;
import com.zehong.system.domain.TLpgVehicleInfo;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-充装记录Service接口
 * 
 * @author zehong
 * @date 2024-07-09
 */
public interface ITLpgAirChargeFilesService 
{
    /**
     * 查询液化石油气-充装记录
     * 
     * @param fGasAirChargeId 液化石油气-充装记录ID
     * @return 液化石油气-充装记录
     */
    public TLpgAirChargeFiles selectTLpgAirChargeFilesById(Long fGasAirChargeId);

    public Integer selectTLpgAirChargeFilesTotal();

    /**
     * 查询液化石油气-充装记录列表
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 液化石油气-充装记录集合
     */
    public List<TLpgAirChargeFiles> selectTLpgAirChargeFilesList(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 根据 集合 里面的 气瓶条码 和 充装记录编号 查询 数据
     * @param tLpgAirChargeFiles s
     * @return r
     */
    public List<TLpgAirChargeFiles> queryALlByBarcodeAndGizId(@Param("list") List<TLpgAirChargeFiles> tLpgAirChargeFiles);

    /**
     * 2024-09-12 wh 查询数据为了导出用 限制导出数量
     * @param tLpgAirChargeFiles t
     * @return r
     */
    public List<TLpgAirChargeFiles> queryAllForExport(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 新增液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    public int insertTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 修改液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    public int updateTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 批量删除液化石油气-充装记录
     * 
     * @param fGasAirChargeIds 需要删除的液化石油气-充装记录ID
     * @return 结果
     */
    public int deleteTLpgAirChargeFilesByIds(Long[] fGasAirChargeIds);

    /**
     * 删除液化石油气-充装记录信息
     * 
     * @param fGasAirChargeId 液化石油气-充装记录ID
     * @return 结果
     */
    public int deleteTLpgAirChargeFilesById(Long fGasAirChargeId);

    /**
     * 导入
     * @param xmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    public Map<String,Object> importLpgAirChargeFileInfo(List<TLpgAirChargeFiles> xmbhList, boolean updateSupport, HttpServletResponse response);

    /**
     * 第三方对接 接收到的数据
     * @param list list
     * @return r
     */
    public int externalDockingCreateLpgAirChargeFileInfo(List<TLpgAirChargeFiles> list);

    /**
     * 修改
     * @param list list
     * @return r
     */
    public int externalDockingUpdateLpgAirChargeFileInfo(List<TLpgAirChargeFiles> list);
}
