package com.zehong.system.service;

import com.zehong.system.domain.TGasUserInfo;

import java.util.List;

/**
 * 燃气用户Service接口
 *
 * @author zehong
 * @date 2023-08-17
 */
public interface ITGasUserInfoService
{
    /**
     * 查询燃气用户
     *
     * @param gasUserId 燃气用户ID
     * @return 燃气用户
     */
    public TGasUserInfo selectTGasUserInfoById(Long gasUserId);

    /**
     * 查询燃气用户列表
     *
     * @param tGasUserInfo 燃气用户
     * @return 燃气用户集合
     */
    public List<TGasUserInfo> selectTGasUserInfoList(TGasUserInfo tGasUserInfo);

    /**
     * 新增燃气用户
     *
     * @param tGasUserInfo 燃气用户
     * @return 结果
     */
    public int insertTGasUserInfo(TGasUserInfo tGasUserInfo);

    /**
     * 修改燃气用户
     *
     * @param tGasUserInfo 燃气用户
     * @return 结果
     */
    public int updateTGasUserInfo(TGasUserInfo tGasUserInfo);

    /**
     * 批量删除燃气用户
     *
     * @param gasUserIds 需要删除的燃气用户ID
     * @return 结果
     */
    public int deleteTGasUserInfoByIds(Long[] gasUserIds);

    /**
     * 删除燃气用户信息
     *
     * @param gasUserId 燃气用户ID
     * @return 结果
     */
    public int deleteTGasUserInfoById(Long gasUserId);

    /**
     * 燃气用户导入
     * @param tGasUserInfoList 燃气用户实体
     * @param isUpdateSupport 是否更新
     * @return
     */
    String importTGasUserInfo(List<TGasUserInfo> tGasUserInfoList, boolean isUpdateSupport);

    /**
     * 查询燃气用户信息
     * @param tGasUserInfo
     */
    List<TGasUserInfo> gasUser(TGasUserInfo tGasUserInfo);
}
