package com.zehong.system.service;

import com.zehong.system.domain.BaseInfoStatistics;
import com.zehong.system.domain.TGasStorageStationInfo;

import java.util.List;

/**
 * 储配站信息Service接口
 * 
 * @author zehong
 * @date 2023-08-14
 */
public interface ITGasStorageStationInfoService 
{
    /**
     * 查询储配站信息
     * 
     * @param stationId 储配站信息ID
     * @return 储配站信息
     */
    public TGasStorageStationInfo selectTGasStorageStationInfoById(Long stationId);

    /**
     * 查询储配站信息列表
     * 
     * @param tGasStorageStationInfo 储配站信息
     * @return 储配站信息集合
     */
    public List<TGasStorageStationInfo> selectTGasStorageStationInfoList(TGasStorageStationInfo tGasStorageStationInfo);

    /**
     * 新增储配站信息
     * 
     * @param tGasStorageStationInfo 储配站信息
     * @return 结果
     */
    public int insertTGasStorageStationInfo(TGasStorageStationInfo tGasStorageStationInfo);

    /**
     * 修改储配站信息
     * 
     * @param tGasStorageStationInfo 储配站信息
     * @return 结果
     */
    public int updateTGasStorageStationInfo(TGasStorageStationInfo tGasStorageStationInfo);

    /**
     * 批量删除储配站信息
     * 
     * @param stationIds 需要删除的储配站信息ID
     * @return 结果
     */
    public int deleteTGasStorageStationInfoByIds(Long[] stationIds);

    /**
     * 删除储配站信息信息
     * 
     * @param stationId 储配站信息ID
     * @return 结果
     */
    public int deleteTGasStorageStationInfoById(Long stationId);

    /**
     * 导入数据
     *
     * @param tGasStorageStationInfoList 数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     */
    String importTGasStorageStationInfo(List<TGasStorageStationInfo> tGasStorageStationInfoList, Boolean isUpdateSupport);

    /**
     * 基础信息统计
     * @param stationId 储配站id
     * @return
     */
    List<BaseInfoStatistics> baseInfoStatistics(Long stationId);
}
