package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmployedPeopleInfoError;

/**
 * 从业人员错误导入记录Service接口
 * 
 * @author zehong
 * @date 2024-06-01
 */
public interface ITEmployedPeopleInfoErrorService 
{
    /**
     * 查询从业人员错误导入记录
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 从业人员错误导入记录
     */
    public TEmployedPeopleInfoError selectTEmployedPeopleInfoErrorById(Long employedPeopleErrorId);

    /**
     * 查询从业人员错误导入记录列表
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 从业人员错误导入记录集合
     */
    public List<TEmployedPeopleInfoError> selectTEmployedPeopleInfoErrorList(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 新增从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    public int insertTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 批量插入错误记录
     * @param employedPeopleInfoErrors e
     * @return r
     */
    public int batchInsertTEmployedPeopleInfoError(List<TEmployedPeopleInfoError> employedPeopleInfoErrors);

    /**
     * 修改从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    public int updateTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 批量删除从业人员错误导入记录
     * 
     * @param employedPeopleErrorIds 需要删除的从业人员错误导入记录ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoErrorByIds(Long[] employedPeopleErrorIds);

    /**
     * 删除从业人员错误导入记录信息
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoErrorById(Long employedPeopleErrorId);

    /**
     * 清除从业人员错误数据
     * @return r
     */
    public int clearImportError();
}
