package com.zehong.system.service;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.TDetectorInfo;

import java.util.List;
import java.util.Map;

/**
 * 探测器Service接口
 * 
 * @author zehong
 * @date 2021-11-02
 */
public interface ITDetectorInfoService 
{
    /**
     * 查询探测器
     * 
     * @param detectorId 探测器ID
     * @return 探测器
     */
    public TDetectorInfo selectTDetectorInfoById(Long detectorId);

    /**
     * 查询探测器
     *
     * @param detectorCode 探测器编号
     * @return 探测器
     */
    public TDetectorInfo selectTDetectorInfoByCode(String detectorCode);

    /**
     * 查询探测器列表
     * 
     * @param tDetectorInfo 探测器
     * @return 探测器集合
     */
    public List<TDetectorInfo> selectTDetectorInfoList(TDetectorInfo tDetectorInfo);

    /**
     * 查询探测器分页列表
     *
     * @param tDetectorInfo 探测器
     * @return 探测器分页集合
     */
    public PageInfo<TDetectorInfo> selectTDetectorInfoPage(TDetectorInfo tDetectorInfo);

    /**
     * 新增探测器
     * 
     * @param tDetectorInfo 探测器
     * @return 结果
     */
    public int insertTDetectorInfo(TDetectorInfo tDetectorInfo);

    public int insertBatch(List<TDetectorInfo> detectorList);

    public int updateBatch(List<TDetectorInfo> detectorList);

    /**
     * 修改探测器
     * 
     * @param tDetectorInfo 探测器
     * @return 结果
     */
    public int updateTDetectorInfo(TDetectorInfo tDetectorInfo);

    /**
     * 批量删除探测器
     * 
     * @param detectorIds 需要删除的探测器ID
     * @return 结果
     */
    public int deleteTDetectorInfoByIds(Long[] detectorIds);

    /**
     * 删除探测器信息
     * 
     * @param detectorId 探测器ID
     * @return 结果
     */
    public int deleteTDetectorInfoById(Long detectorId);
    /**
     * 用户安全监控设备 数量
     * @return
     */
    public Map<String,Object> selectDetectorNum(String enterpriseId);

    /**
     * 获取探测器监控数据
     * @param tDetectorInfo
     * @return
     */
    List<TDetectorInfo> selectDetectorMointor(TDetectorInfo tDetectorInfo);
}
