package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TCountyLevelRegion;

/**
 * 县级行政区Service接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface ITCountyLevelRegionService 
{
    /**
     * 查询县级行政区
     * 
     * @param fId 县级行政区ID
     * @return 县级行政区
     */
    public TCountyLevelRegion selectTCountyLevelRegionById(Long fId);

    /**
     * 查询县级行政区列表
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 县级行政区集合
     */
    public List<TCountyLevelRegion> selectTCountyLevelRegionList(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 根据县（市、区）行政区划编码 集合查询数据
     * @param countyCodes c
     * @return r
     */
    public List<TCountyLevelRegion> queryByCountyCodes(List<String> countyCodes);

    /**
     * 新增县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    public int insertTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 修改县级行政区
     * 
     * @param tCountyLevelRegion 县级行政区
     * @return 结果
     */
    public int updateTCountyLevelRegion(TCountyLevelRegion tCountyLevelRegion);

    /**
     * 批量删除县级行政区
     * 
     * @param fIds 需要删除的县级行政区ID
     * @return 结果
     */
    public int deleteTCountyLevelRegionByIds(Long[] fIds);

    /**
     * 删除县级行政区信息
     * 
     * @param fId 县级行政区ID
     * @return 结果
     */
    public int deleteTCountyLevelRegionById(Long fId);

    /**
     * 获取系统设置县
     * @return
     */
    List<TCountyLevelRegion> getDefaultCountyList();
}
