package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.FProBehInforBrowse;

/**
 * 行业专家库-专家行为浏览Service接口
 * 
 * @author zehong
 * @date 2024-05-09
 */
public interface IFProBehInforBrowseService 
{
    /**
     * 查询行业专家库-专家行为浏览
     * 
     * @param fProBehInforId 行业专家库-专家行为浏览ID
     * @return 行业专家库-专家行为浏览
     */
    public FProBehInforBrowse selectFProBehInforBrowseById(Long fProBehInforId);

    /**
     * 查询行业专家库-专家行为浏览列表
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 行业专家库-专家行为浏览集合
     */
    public List<FProBehInforBrowse> selectFProBehInforBrowseList(FProBehInforBrowse fProBehInforBrowse);

    /**
     * 新增行业专家库-专家行为浏览
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 结果
     */
    public int insertFProBehInforBrowse(FProBehInforBrowse fProBehInforBrowse);

    /**
     * 修改行业专家库-专家行为浏览
     * 
     * @param fProBehInforBrowse 行业专家库-专家行为浏览
     * @return 结果
     */
    public int updateFProBehInforBrowse(FProBehInforBrowse fProBehInforBrowse);

    /**
     * 批量删除行业专家库-专家行为浏览
     * 
     * @param fProBehInforIds 需要删除的行业专家库-专家行为浏览ID
     * @return 结果
     */
    public int deleteFProBehInforBrowseByIds(Long[] fProBehInforIds);

    /**
     * 删除行业专家库-专家行为浏览信息
     * 
     * @param fProBehInforId 行业专家库-专家行为浏览ID
     * @return 结果
     */
    public int deleteFProBehInforBrowseById(Long fProBehInforId);
}
